% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/sr.r
\name{as.sr}
\alias{as.sr}
\alias{as.sr.data.frame}
\alias{as.sr.default}
\alias{as.sr.lm}
\alias{as.sr.matrix}
\alias{as.sr.timeSeries}
\alias{as.sr.xts}
\title{Compute the Sharpe ratio.}
\usage{
as.sr(x,c0=0,ope=1,na.rm=FALSE,epoch="yr")

\method{as.sr}{default}(x, c0 = 0, ope = 1, na.rm = FALSE, epoch = "yr")

\method{as.sr}{matrix}(x, c0 = 0, ope = 1, na.rm = FALSE, epoch = "yr")

\method{as.sr}{data.frame}(x, c0 = 0, ope = 1, na.rm = FALSE,
  epoch = "yr")

\method{as.sr}{lm}(x, c0 = 0, ope = 1, na.rm = FALSE, epoch = "yr")

\method{as.sr}{xts}(x, c0 = 0, ope = 1, na.rm = FALSE, epoch = "yr")

\method{as.sr}{timeSeries}(x, c0 = 0, ope = 1, na.rm = FALSE,
  epoch = "yr")
}
\arguments{
\item{x}{vector of returns, or object of class \code{data.frame}, \code{xts},
or \code{lm}.}

\item{c0}{the 'risk-free' or 'disastrous' rate of return. this is
assumed to be given in the same units as x, \emph{not}
in 'annualized' terms.}

\item{ope}{the number of observations per 'epoch'. For convenience of
interpretation, The Sharpe ratio is typically quoted in 'annualized'
units for some epoch, that is, 'per square root epoch', though returns
are observed at a frequency of \code{ope} per epoch.
The default value is 1, meaning the code will not attempt to guess
what the observation frequency is, and no annualization adjustments
will be made.}

\item{na.rm}{logical.  Should missing values be removed?}

\item{epoch}{the string representation of the 'epoch', defaulting
to 'yr'.}
}
\value{
a list containing the following components:
\item{sr}{the annualized Sharpe ratio.}
\item{df}{the t-stat degrees of freedom.}
\item{c0}{the risk free term.}
\item{ope}{the annualization factor.}
\item{rescal}{the rescaling factor.}
\item{epoch}{the string epoch.}
cast to class \code{sr}.
}
\description{
Computes the Sharpe ratio of some observed returns.
}
\details{
Suppose \eqn{x_i}{xi} are \eqn{n}{n} independent returns of some
asset.
Let \eqn{\bar{x}}{xbar} be the sample mean, and \eqn{s}{s} be
the sample standard deviation (using Bessel's correction). Let \eqn{c_0}{c0}
be the 'risk free rate'.  Then
\deqn{z = \frac{\bar{x} - c_0}{s}}{z = (xbar - c0)/s}
is the (sample) Sharpe ratio.

The units of \eqn{z}{z} are \eqn{\mbox{time}^{-1/2}}{per root time}.
Typically the Sharpe ratio is \emph{annualized} by multiplying by
\eqn{\sqrt{\mbox{ope}}}{sqrt(ope)}, where \eqn{\mbox{ope}}{ope}
is the number of observations
per year (or whatever the target annualization epoch.)

Note that if \code{ope} is not given, the converter from \code{xts}
attempts to infer the observations per year, without regard to
the name of the \code{epoch} given.
}
\examples{
# Sharpe's 'model': just given a bunch of returns.
asr <- as.sr(rnorm(253*3),ope=253)
# or a matrix, with a name
my.returns <- matrix(rnorm(253*3),ncol=1)
colnames(my.returns) <- c("my strategy")
asr <- as.sr(my.returns)
# given an xts object:
\dontrun{
if (require(quantmod)) {
  IBM <- getSymbols('IBM',auto.assign=FALSE)
  lrets <- diff(log(IBM[,"IBM.Adjusted"]))
  asr <- as.sr(lrets,na.rm=TRUE)
}
}
# on a linear model, find the 'Sharpe' of the residual term
nfac <- 5
nyr <- 10
ope <- 253
set.seed(as.integer(charToRaw("determinstic")))
Factors <- matrix(rnorm(ope*nyr*nfac,mean=0,sd=0.0125),ncol=nfac)
Betas <- exp(0.1 * rnorm(dim(Factors)[2]))
Returns <- (Factors \%*\% Betas) + rnorm(dim(Factors)[1],mean=0.0005,sd=0.012)
APT_mod <- lm(Returns ~ Factors)
asr <- as.sr(APT_mod,ope=ope)
# try again, but make the Returns independent of the Factors.
Returns <- rnorm(dim(Factors)[1],mean=0.0005,sd=0.012)
APT_mod <- lm(Returns ~ Factors)
asr <- as.sr(APT_mod,ope=ope)

# compute the Sharpe of a bunch of strategies:
my.returns <- matrix(rnorm(253*3*4),ncol=4)
asr <- as.sr(my.returns)  # without sensible colnames?
colnames(my.returns) <- c("strat a","strat b","strat c","strat d")
asr <- as.sr(my.returns)
}
\author{
Steven E. Pav \email{shabbychef@gmail.com}
}
\references{
Sharpe, William F. "Mutual fund performance." Journal of business (1966): 119-138.
\url{http://ideas.repec.org/a/ucp/jnlbus/v39y1965p119.html}

Lo, Andrew W. "The statistics of Sharpe ratios." Financial Analysts Journal 58, no. 4
(2002): 36-52. \url{http://ssrn.com/paper=377260}
}
\seealso{
\code{\link{reannualize}}

sr-distribution functions, \code{\link{dsr}, \link{psr}, \link{qsr}, \link{rsr}}

Other sr: \code{\link{confint.del_sropt}},
  \code{\link{confint.sr}}, \code{\link{confint.sropt}};
  \code{\link{dsr}}, \code{\link{psr}}, \code{\link{qsr}},
  \code{\link{rsr}}; \code{\link{is.sr}};
  \code{\link{plambdap}}, \code{\link{qlambdap}},
  \code{\link{rlambdap}}; \code{\link{power.sr_test}};
  \code{\link{predint}}; \code{\link{print.del_sropt}},
  \code{\link{print.sr}}, \code{\link{print.sropt}};
  \code{\link{reannualize}}, \code{\link{reannualize.sr}},
  \code{\link{reannualize.sropt}}; \code{\link{se}},
  \code{\link{se.sr}}; \code{\link{sr_equality_test}};
  \code{\link{sr_test}}; \code{\link{sr_unpaired_test}};
  \code{\link{sr_vcov}}; \code{\link{sr}}
}
\keyword{univar}

