% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/d18O_model.r
\name{d18O_model}
\alias{d18O_model}
\title{Function to convert SST data to d18O}
\usage{
d18O_model(SST, d18Ow = 0, mineral = "calcite")
}
\arguments{
\item{SST}{Matrix with a time column (values in days) and an SST column
(values in degrees C)}

\item{d18Ow}{Either a single value (constant d18Ow) or a vector of length
equal to the period in SST data (365 days by default) containing information
about seasonality in d18Ow. Defaults to constant d18Ow of 0 permille VSMOW
(the modern mean ocean value)}

\item{mineral}{String containing the name of the mineralogy (either
\code{"calcite"} or \code{"aragonite"}). Defaults to calcite.}
}
\value{
A vector containing d18O values for each SST value in \code{"SST"}
}
\description{
Takes a matrix of SST data (in degrees C) against time (in days), information
about the d18O value (in permille VSMOW) of the water and how it changes
through the year and the mineralogy of the record (calcite or aragonite).
Converts the SST data to d18O data using an empirical transfer function
(in function of the mineralogy)
}
\examples{
# Create dummy SST data
t <- seq(1, 40, 1)
T <- sin((2 * pi * (seq(1, 40, 1) - 8 + 10 / 4)) / 10)
SST <- cbind(t, T)
# Run d18O model function
d18O <- d18O_model(SST, 0, "calcite")
}
