% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/growth_model.r
\name{growth_model}
\alias{growth_model}
\title{Function that models a d18O curve through SST and GR sinusoids}
\usage{
growth_model(
  pars,
  T_per = 365,
  G_per = 365,
  years = 1,
  t_int = 1,
  mineral = "calcite",
  d18Ow = "default",
  Dsam,
  Osam,
  t_maxtemp = 182.5,
  plot = FALSE,
  MC = 1000,
  D_err = NULL,
  O_err = NULL,
  return = "SSR"
)
}
\arguments{
\item{pars}{List of parameters for temperature and growth rate sinusoids
\code{pars <- c(T_amp, T_pha, T_av, G_amp, G_pha, G_av, G_skw)}}

\item{T_per}{Period of SST sinusoid (in days; default = 365)}

\item{G_per}{Period of growth rate sinusoid (in days; default = 365)}

\item{years}{Number of years to be modelled (default = 1)}

\item{t_int}{Time interval (in days; default = 1)}

\item{mineral}{Mineralogy of record (default = "calcite")}

\item{d18Ow}{Either a single value (constant d18Ow) or a vector of length
equal to the period in SST data (365 days by default) containing information
about seasonality in d18Ow. Defaults to constant d18Ow of 0 permille VSMOW
(the modern mean ocean value)}

\item{Dsam}{Vector of \code{D} values serving as input (keep unit consistent
throughout model)}

\item{Osam}{Vector of \code{d18Oc} values serving as input (in permille VPDB)}

\item{t_maxtemp}{Timing of the warmest day of the year (in julian day;
default = 182.5, or May 26th halfway through the year)}

\item{plot}{Should results of modelling be plotted? \code{TRUE/FALSE}}

\item{MC}{Number of Monte Carlo simulations to apply for error propagation
Default = 1000}

\item{D_err}{OPTIONAL: Vector containing errors on \code{Dsam}}

\item{O_err}{OPTIONAL: Vector containing errors on \code{Osam}}

\item{return}{String indicating whether to return just the Sum of Squared
Residuals ("SSR") or a matrix containing the results of the model and the
propagated uncertainties (if applicable)}
}
\value{
Depending on the value of the "return" parameter either a single
value representing the Sum of Squared Residuals ("SSR") as a measure for
the closeness of the match between modelled d18O and input values, or a
matrix containing the full result of the modelling including propagated
uncertainties if applicable.
}
\description{
The core function of the ShellChron growth model. Uses growth
rate and SST (Sea Surface Temperature) sinusoids to model d18O
data to be matched with the input. In the ShellChron modelling
routine, this function is optimized using the SCEUA algorithm
and applied on sliding windows through the dataset to estimate
the age of each datapoint
}
\examples{
# Set parameters
G_amp <- 20
G_per <- 365
G_pha <- 100
G_av <- 15
G_skw <- 70
T_amp <- 20
T_per <- 365
T_pha <- 150
T_av <- 15
pars <- c(T_amp, T_pha, T_av, G_amp, G_pha, G_av, G_skw)
d18Ow <- 0
# Create dummy data
Dsam <- seq(1, 40, 1)
Osam <- sin((2 * pi * (seq(1, 40, 1) - 8 + 30 / 4)) / 30)
# Test returning residual sum of squares for optimization
SSR <- growth_model(pars, T_per, G_per, Dsam = Dsam, Osam = Osam,
    return = "SSR")
# Test returning full model result
resmat <- growth_model(pars, T_per, G_per, Dsam = Dsam, Osam = Osam,
    return = "result")
}
\references{
package dependencies: ggplot2 3.2.1
function dependencies: temperature_curve, d18O_model, growth_rate_curve,
mc_err_orth
}
