uiSetting <-
  tabPanel("",
           icon = icon("fas fa-cog"),
           h3("Settings"),
           h4("IRT models setting"),
           p("Set the number of cycles for IRT 1PL, 2PL, 3PL and 4PL models."),
           fluidPage(column(2, numericInput(inputId = "ncycles",
                                            label = "Number of cycles",
                                            value = 2000,
                                            min = 1,
                                            max = 999999))),
           h4("Figure downloads"),
           p("Here you can change setting for download of figures. "),
           fluidPage(column(2, numericInput(inputId = "setting_figures_text_size",
                                            label = "Text size [pts]",
                                            value = 12,
                                            min = 6,
                                            max = 20)),
                     column(2, numericInput(inputId = "setting_figures_height",
                                            label = "Height [in]",
                                            value = 4,
                                            min = 1,
                                            max = 16)),
                     column(2, numericInput(inputId = "setting_figures_width",
                                            label = "Width [in]",
                                            value = 8,
                                            min = 1,
                                            max = 16)),
                     column(2, numericInput(inputId = "setting_figures_dpi",
                                            label = "Plot resolution",
                                            value = 600,
                                            min = 72,
                                            max = 600))
           ))
