% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute.SCF.R
\name{compute.SCF}
\alias{compute.SCF}
\title{Compute the sightability correction factor given a sightability and covariates}
\usage{
compute.SCF(
  data,
  sight.model,
  sight.beta,
  sight.beta.cov,
  check.args = FALSE,
  adjust = TRUE
)
}
\arguments{
\item{data}{Data.frame containing covariates for sightability model}

\item{sight.model}{Formula with sightability model}

\item{sight.beta}{Parameter estimates (from fitted sightability model}

\item{sight.beta.cov}{Estimated variance-covariance matrix for  parameter estimates
from fitted sightability model.}

\item{check.args}{Should the sightability model arguments be checked for consistency/}

\item{adjust}{Should the sightability value be adjusted for the sight.beta.cov.}
}
\value{
Vector of sightability factors (SCF)
}
\description{
Compute the sightability correction factor given a sightability and covariates
}
\examples{
sightability.table <- data.frame(VegCoverClass=1:5)
sight.beta <- c(4.2138, -1.5847)
sight.beta.cov <- matrix(c(0.7821634, -0.2820000,-0.2820000,  0.1114892), nrow=2)
sightability.table$detect.prob <- compute.detect.prob( sightability.table, 
                                                       ~VegCoverClass, 
                                                       sight.beta, 
                                                       sight.beta.cov)
sightability.table$SCF         <- compute.SCF        ( sightability.table, 
                                                       ~VegCoverClass, 
                                                       sight.beta, 
                                                       sight.beta.cov)
sightability.table
#"Note that the SCF != 1/detect.prob because of correction terms for covariance of beta.terms"

}
\seealso{
\code{\link{compute.detect.prob}}
}
\author{
Schwarz, C. J. \email{cschwarz.stat.sfu.ca@gmail.com}.
}
\keyword{methods}
