% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pca_dfm.R
\name{estimate_dfm}
\alias{estimate_dfm}
\title{Dynamic Factor Model Estimation}
\usage{
estimate_dfm(
  X,
  r = NULL,
  p = 1,
  ic = c("IC2", "IC1", "IC3"),
  max_factors = NULL,
  standardize = TRUE,
  verbose = FALSE
)
}
\arguments{
\item{X}{Matrix or data frame where rows are observations and columns are
variables.}

\item{r}{Number of factors. If NULL, determined by information criterion.}

\item{p}{Number of lags in factor VAR dynamics. Default 1.}

\item{ic}{Character string specifying information criterion for factor
selection: "IC1", "IC2", or "IC3" (Bai & Ng, 2002). Default "IC2".}

\item{max_factors}{Maximum number of factors to consider. Default
min(10, floor(ncol(X)/2)).}

\item{standardize}{Logical. Standardize variables before estimation.
Default TRUE.}

\item{verbose}{Logical for progress messages.}
}
\value{
A list of class "signaly_dfm" containing:
\describe{
\item{factors}{Matrix of estimated latent factors (T x r)}
\item{loadings}{Matrix of factor loadings (p x r)}
\item{var_coefficients}{VAR coefficient matrices for factor dynamics}
\item{idiosyncratic_var}{Idiosyncratic variance estimates}
\item{r_selected}{Number of factors selected}
\item{ic_values}{Information criterion values}
\item{fitted_values}{Fitted values from the model}
\item{residuals}{Residuals (idiosyncratic components)}
}
}
\description{
Estimates a Dynamic Factor Model (DFM) to extract common latent factors
from panel data. Uses principal components as initial estimates and
optionally refines via EM algorithm.
}
\details{
The DFM assumes:
\deqn{X_{it} = \lambda_i' F_t + e_{it}}

where \eqn{F_t} are common factors, \eqn{\lambda_i} are loadings, and
\eqn{e_{it}} are idiosyncratic errors. The factors follow VAR dynamics:
\deqn{F_t = A_1 F_{t-1} + ... + A_p F_{t-p} + u_t}

Factor selection uses the Bai & Ng (2002) information criteria which
penalize over-fitting while consistently estimating the true number of
factors.
}
\examples{
set.seed(123)
n <- 100
p <- 20
X <- matrix(rnorm(n * p), ncol = p)
result <- estimate_dfm(X, r = 2)
print(dim(result$factors))

}
\references{
Bai, J., & Ng, S. (2002). Determining the number of factors in approximate
factor models. Econometrica, 70(1), 191-221.

Stock, J. H., & Watson, M. W. (2002). Forecasting using principal components
from a large number of predictors. Journal of the American Statistical
Association, 97(460), 1167-1179.
}
