\name{mc.correlation}
\alias{mc.correlation}
\title{
Monte Carlo Estimation Of The Correlation Matrix
}
\description{
This function provides a Monte Carlo correlation matrix estimate. It estimates the correlation matrix of the distribution of the random vector with specified univariate marginals
when the Li-Hammond method is used.
}
\usage{
mc.correlation(R.mc = 10000, cor.matrix, distr = "logistic", R.norm = 1000)
}
\arguments{
  \item{R.mc}{
integer indicating the Monte Carlo replications. Default is 10000.
}
  \item{cor.matrix}{
matrix describing the correlation matrix of the standard multivariate normal distribution.
}
  \item{distr}{
logistic or extreme. 
}
  \item{R.norm}{
integer determining the sample size of the standard multivariate normal distribution for each Monte Carlo replication. Default is 1000.
}
}
\value{
\item{target.normal}{Correlation matrix of the standard multivariate normal distribution.}
\item{mc.normal}{Monte Carlo estimate of \code{cor.matrix}.}
\item{mc.marginal}{Monte Carlo estimate of the correlation matrix of the multivariate distribution with \code{distr} univariate marginals.}
\item{pd.marginal}{\code{TRUE} if \code{mc.marginal} is semi-positive definite and \code{FALSE}, if otherwise.}
}
\references{
Li,S.T. and Hammond, J.L. (1975). Generation of pseudorandom numbers with specified univariate distributions and correlation coefficients.
Systems, Man and Cybernetics, IEEE Transacions on 5, pp 557-561.
}
\author{
Anestis Touloumis
}
\seealso{
\code{\link{rtransfam}}
}
\keyword{ internal }
