\name{rmar.cumlink}
\alias{rmar.cumlink}
\title{
Simulating Correlated Ordinal Multinomial Responses
}
\description{
This function generates correlated ordinal multinomial responses assuming a threshold that gives rise to marginal cumulative link models. The correlation structure refers to the correlation of the underlying latent variables.
}
\usage{
rmar.cumlink(clsize, lin.pred, cor.matrix, cuts, link = "probit")
}
\arguments{
  \item{clsize}{
integer indicating the common cluster size.
}
  \item{lin.pred}{
matrix with \code{clsize} columns.
}
  \item{cor.matrix}{
matrix or vector that describes the correlation structure of the underlying latent variables. See details for more info.
}
  \item{cuts}{
list or vector that includes the cutpoints for each element of the cluster.
}
  \item{link}{
probit or logistic or complementary log-log or cauchit. 
}
}
\details{
\enumerate{
\item The row dimension of \code{lin.pred} equals the sample size.
\item If \code{cor.matrix} is a matrix, then the Li-Hammond method is used and the correlation matrix corresponds to the multivariate normal distribution.
Otherwise, it must contain non-negative values. For the cloglog link it generates a random vector from the multivariate Gumbel distribution.
For the logit link, the random vector is generated by the difference of two random vectors from the multivariate Gumbel distribution.
\item If \code{cuts} is a vector then common cutpoints are used for each element of the cluster.  
\item \code{lin.pred} contains the linear predictor of the marginal cumulative link model with no intercepts.
}
}
\value{
\item{Ysim}{the correlated ordinal multinomial responses.}
\item{correlation}{the correlation matrix of the underlying continuous variables.}
\item{cuts}{a list containing the cutpoints.}
\item{error}{the simulated noise from the underlying regression.}
}
\references{
Li, S.T. and Hammond, J.L. (1975). Generation of pseudorandom numbers with specified univariate distributions and correlation coefficients.
Systems, Man and Cybernetics, IEEE Transacions on 5, pp 557-561.  

Balakrishnan, N. (1992). Handbook of the logistic distribution. CRC.

Gumbel, E.J. (1961). Multivariate extremal distributions. Bulletin de l'Institut International de Statistiques.
}
\author{
Anestis Touloumis
}
\seealso{
\code{\link{rtransfam}},\code{\link{rmar.bcl}}
}
\examples{
\dontrun{
Simulating correlated ordinal multinomial responses of cluster size two,
under a marginal cumulative probit model. The linear predictor follows a 
bivariate standard normal distribution with correlation=0.8. The cutpoints
are -1.5 and 1.5 and the correlation coefficient of the undelying statndard
multivariate normal distribution is 0.5.
}
rmar.cumlink(clsize=2,lin.pred=rmvnorm(20,sigma=toeplitz(c(1,0.8))),
             cuts=c(-Inf,-1.5,1.5,Inf),cor.matrix=toeplitz(c(1,0.5)))
}
