% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimAnova.R
\name{SimAnova}
\alias{SimAnova}
\title{Function for decomposing the simulation into ANOVA-based effect sizes}
\usage{
SimAnova(formula, dat, subset = NULL, rates = TRUE)
}
\arguments{
\item{formula}{an R formula generally of a form suitable for \code{\link{lm}} or
\code{\link{aov}}. However, if the dependent variable (left size of the equation) is omitted
then all the dependent variables in the simulation will be used and the result will return
a list of analyses}

\item{dat}{an object returned from \code{\link{runSimulation}} of class \code{'SimDesign'}}

\item{subset}{an optional argument to be passed to \code{\link{subset}} with the same name. Used to
subset the results object while preserving the associated attributes}

\item{rates}{logical; does the dependent variable consist of rates (e.g., returned from
\code{\link{ECR}} or \code{\link{EDR}})? Default is TRUE, which will use the logit of the DV
to help stabilize the proportion-based summary statistics when computing the parameters and
effect sizes}
}
\description{
Given the results from a simulation with \code{\link{runSimulation}} form an ANOVA table (without
p-values) with effect sizes based on the eta-squared statistic. These results provide approximate
indications of observable simulation effects, therefore these ANOVA-based results are generally useful
as exploratory rather than inferential tools.
}
\examples{

data(BF_sim)

# all results (not usually good to mix Power and Type I results together)
SimAnova(alpha.05.F ~ (groups_equal + distribution)^2, BF_sim)

# only use anova for Type I error conditions
SimAnova(alpha.05.F ~ (groups_equal + distribution)^2, BF_sim, subset = var_ratio == 1)

# run all DVs at once using the same formula
SimAnova(~ groups_equal * distribution, BF_sim, subset = var_ratio == 1)

}

