% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimFunctions.R
\name{SimFunctions}
\alias{SimFunctions}
\title{Template-based generation of the Generate-Analyse-Summarise functions}
\usage{
SimFunctions(
  filename = NULL,
  dir = getwd(),
  comments = FALSE,
  singlefile = TRUE,
  summarise = TRUE,
  generate = TRUE,
  openFiles = TRUE
)
}
\arguments{
\item{filename}{a character vector indicating whether the output should be saved to two respective files
containing the simulation design and the functional components, respectively. Using this option
is generally the recommended approach when beginning to write a Monte Carlo simulation}

\item{dir}{the directory to write the files to. Default is the working directory}

\item{comments}{logical; include helpful comments? Default is \code{FALSE}}

\item{singlefile}{logical; when \code{filename} is included, put output in one files? When \code{FALSE} the
output is saved to two separate files containing the functions and design definitions. The two-file format
often makes organization and debugging slightly easier, especially for larger Monte Carlo simulations.
Default is \code{TRUE}}

\item{summarise}{include \code{summarise} function? Default is \code{TRUE}}

\item{generate}{include \code{generate} function? Default is \code{TRUE}}

\item{openFiles}{logical; after files have been generated, open them in your text editor (e.g., if Rstudio is running
the scripts will open in a new tab)?}
}
\description{
This function prints template versions of the required \code{Design} and Generate-Analyse-Summarise functions
for \code{SimDesign} to run simulations. Templated output comes complete with the correct inputs,
class of outputs, and optional comments to help with the initial definitions.
Use this at the start of your Monte Carlo simulation study. Following
the definition of the \code{SimDesign} template file please refer to detailed the information
in \code{\link{runSimulation}} for how to edit this template to make a working simulation study.
}
\details{
The recommended approach to organizing Monte Carlo simulation files is to first save the template generated
by this function to the hard-drive by passing a suitable \code{filename} argument (which, if users are interacting
with R via the RStudio IDE, will also open the template file after it has been saved). For larger simulations, two
separate files could also be used (achieved by passing \code{singlefile = FALSE}),
and may be easier for debugging/sourcing the simulation code; however, this is a
matter of preference and does not change any functionality in the package.
}
\examples{

SimFunctions()
SimFunctions(comments = TRUE) #with helpful comments

\dontrun{

# write output to two files (recommended for larger MCSs)
SimFunctions('mysim', singlefile = FALSE)

# write output files to a single file with comments
SimFunctions('mysim', comments = TRUE)
}

}
\references{
Chalmers, R. P., & Adkins, M. C.  (2020). Writing Effective and Reliable Monte Carlo Simulations
with the SimDesign Package. \code{The Quantitative Methods for Psychology, 16}(4), 248-280.
\doi{10.20982/tqmp.16.4.p248}

Sigal, M. J., & Chalmers, R. P. (2016). Play it again: Teaching statistics with Monte
Carlo simulation. \code{Journal of Statistics Education, 24}(3), 136-156.
\doi{10.1080/10691898.2016.1246953}
}
\seealso{
\code{\link{runSimulation}}
}
\author{
Phil Chalmers \email{rphilip.chalmers@gmail.com}
}
