% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract.tabEtot.R
\name{extract.tabEtot}
\alias{extract.tabEtot}
\title{Table of concentrations}
\usage{
extract.tabEtot(tabR,beta_fun)
}
\arguments{
\item{tabR}{Dataframe of simulation results, which is an output of \code{\link{simul.evol.enz.multiple}}}

\item{beta_fun}{Matrix of co-regulation coefficients}
}
\value{
Dataframe of \eqn{n+p+2} columns, where \eqn{n} is the number of enzymes and \eqn{p} is the number of regulation groups.
The \eqn{n} first columns are the concentrations of enzymes 1 to \eqn{n} (named \code{E1, ..., En}), the following \eqn{p} are the sum of concentrations in regulations groups from group 1 to \eqn{p} (named \code{Ep1, ..., Epp}), the second last column is the total concentration (named \code{Etot}) and the last column is the simulation number (named \code{sim}).
The column are named: \code{E1, ..., En, Eq1, ... Eqp, Etot, sim}.
The row number of the output dataframe is the same as \code{tabR}.
The last column \code{"sim"} is present only if input \code{tabR} has a column named \code{"sim"}.
}
\description{
Creates a table of all absolute concentrations from simulation results, or any table of enzyme concentrations (enzyme by column)
}
\details{
From the result table \code{tabR} of simulations, extract the values of absolute concentrations of each enzymes,
and computes the absolute concentrations \eqn{E^q} in each regulation and the total concentration at each time step.

The input \code{tabR} is the output \code{tabR} of function \code{\link{simul.evol.enz.multiple}}, or possibly the output \code{res_sim} of function \code{\link{simul.evol.enz.multiple}}.

The function also works for any table \code{tabR} that has \eqn{n} columns (enzyme concentrations in columns), and any number of rows. The last column \code{"sim"} is not an obligation, but if present, need to be the last column.
}
\examples{
#one group
n <- 3
beta <- diag(1,n)
beta[1,2] <- 0.1 ; beta[2,1] <- 1/beta[1,2]
some.E <- matrix(30,ncol=n,nrow=3)
some.E[2,] <- c(20,50,10)
some.E[3,] <- runif(n,1,100)
tabEtot <- extract.tabEtot(some.E,beta)

\donttest{
#With saved simulation
data(data_sim_RegPos)
tabEtot <- extract.tabEtot(data_sim_RegPos$tabR,data_sim_RegPos$param$beta)
}


}
\seealso{
Use function \code{\link{simul.evol.enz.multiple}} to run simulations.
}
