% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_delayed_effect.R
\name{generate_delayed_effect}
\alias{generate_delayed_effect}
\alias{assumptions_delayed_effect}
\alias{hr_after_onset_from_PH_effect_size}
\alias{cen_rate_from_cen_prop_delayed_effect}
\alias{true_summary_statistics_delayed_effect}
\title{Generate Dataset with delayed effect}
\usage{
generate_delayed_effect(condition, fixed_objects = NULL)

assumptions_delayed_effect(print = interactive())

hr_after_onset_from_PH_effect_size(
  design,
  target_power_ph = NA_real_,
  final_events = NA_real_,
  target_alpha = 0.025
)

cen_rate_from_cen_prop_delayed_effect(design)

true_summary_statistics_delayed_effect(
  Design,
  cutoff_stats = NULL,
  milestones = NULL,
  fixed_objects = NULL
)
}
\arguments{
\item{condition}{condition row of Design dataset}

\item{fixed_objects}{additional settings, see details}

\item{print}{print code to generate parameter set?}

\item{design}{design data.frame}

\item{target_power_ph}{target power under proportional hazards}

\item{final_events}{target events for inversion of Schönfeld Formula
defaults to \code{condition$final_events}}

\item{target_alpha}{target one-sided alpha level for the power calculation}

\item{Design}{Design data.frame for delayed effect}

\item{cutoff_stats}{(optionally named) cutoff times, see details}

\item{milestones}{(optionally named) vector of times at which milestone survival should be calculated}
}
\value{
For generate_delayed_effect: A dataset with the columns t (time) and trt
(1=treatment, 0=control), evt (event, currently TRUE for all observations)

For assumptions_delayed_effect: a design tibble with default values invisibly

For hr_after_onset_from_PH_effect_size: the design data.frame passed as
argument with the additional column hazard_trt.

for cen_rate_from_cen_prop_delayed_effect: design data.frame with the
additional column random_withdrawal

For true_summary_statistics_delayed_effect: the design data.frame
passed as argument with additional columns
}
\description{
Generate Dataset with delayed effect

Create an empty assumtions data.frame for generate_delayed_effect

Calculate hr after onset of treatment effect

Calculate true summary statistics for scenarios with delayed treatment effect
}
\details{
Condidtion has to contain the following columns:
\itemize{
\item n_trt number of paitents in treatment arm
\item n_ctrl number of patients in control arm
\item delay time until onset of effect
\item hazard_ctrl hazard in the control arm = hazard before onset of treatment
effect
\item hazard_trt hazard in the treatment arm afert onset of treatment effect
}

If fixed_objects is given and contains an element \code{t_max}, then this is used
as the cutoff for the simulation used internally. If t_max is not given in
this way the 1-(1/10000) quantile of the survival distribution in the control
or treatment arm is used (which ever is larger).

assumptions_delayed_effect generates a default design \code{data.frame}
for use with generate_delayed_effect. If print is \code{TRUE} code to produce
the template is also printed for copying, pasting and editing by the user.
(This is the default when run in an interactive session.)

\code{hr_after_onset_from_PH_effect_size} calculates the hazard ratio
after onset of treatment effect as follows: First, the hazard ratio needed
to archive the desired power under proportional hazards is calculated by
inverting Schönfeld's sample size formula. Second the median survival times
for both arm under this hazard ratio and proportional hazards are
calculated. Finally the hazard rate of the treatment arm after onset of
treatment effect is set such that the median survival time is the same as
the one calculated under proportional hazards.

This is a heuristic and to some extent arbitrary approach to calculate
hazard ratios that correspond to reasonable and realistic scenarios.

cen_rate_from_cen_prop_delayed_effect takes the proportion of
censored patients from the column \code{censoring_prop}. This column describes
the proportion of patients who are censored randomly before experiencing an
event, without regard to administrative censoring.

\code{cutoff_stats} are the times used to calculate the statistics like average
hazard ratios and RMST, that are only calculated up to a certain point.
}
\section{Functions}{
\itemize{
\item \code{generate_delayed_effect()}: simulates a dataset with delayed
treatment effect

\item \code{assumptions_delayed_effect()}: generate default assumptions \code{data.frame}

\item \code{hr_after_onset_from_PH_effect_size()}: Calculate hr after onset of treatment effect of the hazards from PH effect size

\item \code{cen_rate_from_cen_prop_delayed_effect()}: calculate censoring rate from censoring proportion

\item \code{true_summary_statistics_delayed_effect()}: calculate true summary statistics for delayed effect

}}
\examples{
one_simulation <- merge(
    assumptions_delayed_effect(),
    design_fixed_followup(),
    by=NULL
  ) |>
  head(1) |>
  generate_delayed_effect()
head(one_simulation)
tail(one_simulation)
Design <- assumptions_delayed_effect()
Design
my_design <- merge(
  assumptions_delayed_effect(),
  design_fixed_followup(),
  by=NULL
)

my_design$hazard_ctrl <- 0.05
my_design$final_events <- ceiling((my_design$n_trt + my_design$n_ctrl)*0.75)
my_design$hazard_trt <- NA
my_design <- hr_after_onset_from_PH_effect_size(my_design, target_power_ph=0.9)
my_design
design <- expand.grid(
  delay=seq(0, 10, by=5),            # delay of 0, 1, ..., 10 days
  hazard_ctrl=0.2,                   # hazard under control and before treatment effect
  hazard_trt=0.02,                   # hazard after onset of treatment effect
  censoring_prop=c(0.1, 0.25, 0.01), # 10\%, 25\%, 1\% random censoring
  followup=100,                      # followup of 100 days
  n_trt=50,                          # 50 patients treatment
  n_ctrl=50                          # 50 patients control
)
cen_rate_from_cen_prop_delayed_effect(design)
my_design <- merge(
    assumptions_delayed_effect(),
    design_fixed_followup(),
    by=NULL
  )
my_design <- true_summary_statistics_delayed_effect(my_design)
my_design
}
