% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simPheno.R
\name{gene.effect}
\alias{gene.effect}
\title{Get genetic effect}
\usage{
gene.effect(geno, gene.coef, model = c("epistasis"), ...)
}
\arguments{
\item{geno}{a data.frame or a matrix containing the genotype information.}

\item{gene.coef}{a list with the coefficients of genetic effects.}

\item{model}{a string specifying the genetic model to use for the simulation.
Default is "epistasis".}

\item{...}{not used.}
}
\value{
a data.frame including genetic effects.
}
\description{
Get genetic effect for each individual based on the genotype.
}
\examples{
# genotype file: rows are individuals and columns are SNPs
fgeno.path <- system.file("extdata", "10SNP.txt", package="SimPhe")

# get genotype
geno <- read.geno(fgeno.path, ftype = "snp.head")

# take a look at geno and gene.coef
geno
gene.coefficients

# get gene effects
gene.effect(geno, gene.coefficients)
}
\author{
Beibei Jiang \email{beibei_jiang@psych.mpg.de} and
        Benno Pütz \email{puetz@psych.mpg.de}
}
