% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getgenotype.R
\name{read.geno}
\alias{read.geno}
\title{Read genotype data based on the file format}
\usage{
read.geno(fname = NULL, verbose = getOption("verbose"), run = TRUE,
  cleanup = TRUE, ftype = c("ind.head", "plink", "snp.head"),
  plink.path = NULL, ...)
}
\arguments{
\item{fname}{a string specifying the file to read genotype information from}

\item{verbose}{when set show the commands that are to be called through \code{system}.}

\item{run}{when set (default) execute the \code{system} calls.}

\item{cleanup}{when set (default) remove intermediate files before returning.}

\item{ftype}{genotype file format, it accepts three options:
\describe{
\item{"plink":}{plink format (\code{.bed}, \code{.bim}, \code{.fam} or \code{.map}, \code{.ped});}
\item{"ind.head":}{columns are the indviduals and lines are SNPs;}
\item{"snp.head":}{columns are SNPs and lines are indviduals.}}
                   For "plink", \code{fgeno} needs to be given
                   without suffix and \code{plink.path} may need to be
                   assigned by the user because \code{plink} will be run
                   from within \pkg{SimPhe}. More detail see \code{plink.path}.
                   For the other options, \code{fgeno} should be the full
                   name (with suffix and path if necessary) of the
                   genotype file.
                   Of course, this does not apply if \code{fgeno} is
                   provided as a data frame.}

\item{plink.path}{path of plink executable. Only needed when the \code{ftype}
is "\code{plink}". Default is NULL. The function will detect the plink path with
\code{system("where plink")} for Windows users and \code{system("which plink")} for
Linux and MacOS users. But there is no garantee that the commands work on all devices.
If the path cannot be determined or the executable cannot be called from \code{read.geno},
then users have to try other formats.}

\item{...}{not used.}
}
\value{
a dataframe of genotype data: columns are the SNPs; rows are indviduals.
}
\description{
Read genotype data.
}
\details{
If it is plink file format (.bed, .bim, .fam),
make sure that plink has already been installed in the system
}
\examples{
## "snp.head" genotype file: rows are individuals and columns are SNPs
# get full path of example file
fgeno.path <- system.file("extdata", "10SNP.txt", package="SimPhe")

geno <- read.geno(fgeno.path, ftype = "snp.head")
head(geno)

## "plink" genotype file: 1).map and .ped; 2).bed, .fam and .bim
# get directory of plink example file
fpath <- strsplit(fgeno.path, "10SNP.txt")

#### Note: before run this example, specify your installation path of plink ####
# geno <- read.geno(paste0(fpath, "bdemo"), ftype = "plink", plink.path = "user's plink path")
}
\author{
Beibei Jiang \email{beibei_jiang@psych.mpg.de} and
        Benno Pütz \email{puetz@psych.mpg.de}
}
