% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SkeweDF_functions.R
\name{local_fit_function}
\alias{local_fit_function}
\title{Local optimization of a given function given empirical data and parameter bounds}
\usage{
local_fit_function(
  param_bounds,
  data,
  model_fn_name,
  weighted_rt = FALSE,
  par_chunk = 100,
  par_chunk_size = 10,
  n_cores = 1,
  clust,
  left_trunc = 1,
  right_trunc = left_trunc + length(data) - 1
)
}
\arguments{
\item{param_bounds}{A list of sequences which indicate space where parameters should be generated and fit}

\item{data}{Vector of observed values}

\item{model_fn_name}{Character vector indicating name of function of theoretical model to be used. For example, for Generalized_Yule(n, rho, alpha), model_fn_name <- 'Generalied Yule'}

\item{weighted_rt}{Boolean used to determine if the weighted right-tail cumulative distribution function should be used or not.}

\item{par_chunk}{Integer used to indicate number of optimization chunks to be run. Total number of rows in the output table = par_chunk * par_chunk_size}

\item{par_chunk_size}{Integer used to indicate number of starting parameters to be generated and optimized in a given chunk. Total number of rows in the output table = par_chunk * par_chunk_size}

\item{n_cores}{Integer used to indicate number of cores to be used for this function if a socket cluster object is not defined.}

\item{clust}{socket cluster object from 'parallel::makeCluster()'. This is used if you have already generated a socket cluster object and would like to run this functoin on it. If no object is defined, one will be made for this function call.}

\item{left_trunc}{Int used to determine starting index of model to use for optimization}

\item{right_trunc}{Int used to determine ending index of model to use for optimization}
}
\description{
This function generates a table of optimized parameters and Psi Criterion for a given function within specified starting parameter bounds. This function uses Limited Memory BFGS as it's gradient descent algorithm.
}
