% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cusum.R
\name{cusum}
\alias{cusum}
\alias{plot.cusum}
\alias{print.cusum}
\alias{signal.cusum}
\title{Calculates a sequence of Cusum statistics}
\usage{
cusum(X, k, h, initial = 0, reset = TRUE)

\method{print}{cusum}(x, ...)

\method{plot}{cusum}(x, indexes = NULL, emphOOC = TRUE, ...)

\method{signal}{cusum}(object, ...)
}
\arguments{
\item{X}{A numeric vector.}

\item{k}{The reference value.}

\item{h}{The upper control limit.}

\item{initial}{The starting value of the Cusum (\emph{C[0]}).}

\item{reset}{Logical indicating whether the Cusum is reset to 0 after crossing the control limit.}

\item{x}{Object of class \code{cusum}}

\item{indexes}{A vector of indexes that select the elements of the cusum statistics that will be plotted.}

\item{emphOOC}{A logical indicating whether out of control points should be emphasized in red.}

\item{object}{Object of class \code{cusum}}

\item{\dots}{Additional arguments to \code{\link{print.default}} or \code{\link{plot.default}}.  Ignored by the \code{signal} method.}
}
\value{
A object of class \code{cusum}, which is a vector of the Cusum statistics, along with the following attributes:
\code{X}, \code{k}, \code{h}, \code{initial}, and \code{reset} (which correspond to the original arguments provided to
the function) and \code{resetCounter}, a vector of integers corresponding to \code{cusum} that indicates when the 
Cusum resets.
}
\description{
Calculates a sequence of one-sided upper Cusum statistics given the reference value and
the control limit.
}
\details{
Cusum is assumed to be of the form: \emph{C[i] = max(0, C[i-1] + X[i] - k)},
where the signal occurs when \emph{C[i] > h}.  Note that \code{X} can be the Cusum scores, or weights,
given by the log-likelihood ratio, in which case \code{k = 0} would make sense.
}
\section{Methods (by generic)}{
\itemize{
\item \code{print}: Prints the \code{cusum} object by only showing the Cusum statistics and suppressing the attributes.

\item \code{plot}: Plots the \code{cusum} object.

\item \code{signal}: Prints the indexes in a \code{cusum} object that exceed the control limit
}}
\examples{
y <- cusum(rnorm(50), 0.2, 2)
y

# Plot the cusum
plot(y)

# Show the indexes where the chart signaled
signal(y)

# A look at the attributes
attributes(y)
}
\references{
Hawkins DM and Olwell DH. (1998) Cumulative Sum Charts and Charting for Quality Improvement. Springer.
}

