
SoftForestPredDepth5 = function(trainresponse, train, test, num.features, ntry, keep = FALSE)
{
  stopifnot(is.vector(trainresponse))
  if(sum(is.data.frame(train), is.matrix(train)) != 1) stop("Training data must be matrix or data frame.")
  if(sum(is.data.frame(test), is.matrix(test)) != 1) stop("Test data must be matrix or data frame.")
  stopifnot(is.numeric(num.features))
  stopifnot(length(num.features) == 1)
  stopifnot(is.numeric(ntry))
  stopifnot(length(ntry) == 1)
  
  Response01 = BestForestSplit(trainresponse, train, num.features, ntry)
  Response11 = BestForestSplit(trainresponse, train, num.features, ntry, weights = Response01$weights0)
  Response12 = BestForestSplit(trainresponse, train, num.features, ntry, weights = Response01$weights1)
  Response21 = BestForestSplit(trainresponse, train, num.features, ntry, weights = Response01$weights0*Response11$weights0)
  Response22 = BestForestSplit(trainresponse, train, num.features, ntry, weights = Response01$weights0*Response11$weights1)
  Response23 = BestForestSplit(trainresponse, train, num.features, ntry, weights = Response01$weights1*Response11$weights0)
  Response24 = BestForestSplit(trainresponse, train, num.features, ntry, weights = Response01$weights1*Response11$weights1)
  Response31 = BestForestSplit(trainresponse, train, num.features, ntry, weights = Response01$weights0*Response11$weights0*Response21$weights0)
  Response32 = BestForestSplit(trainresponse, train, num.features, ntry, weights = Response01$weights0*Response11$weights0*Response21$weights1)
  Response33 = BestForestSplit(trainresponse, train, num.features, ntry, weights = Response01$weights0*Response11$weights1*Response22$weights0)
  Response34 = BestForestSplit(trainresponse, train, num.features, ntry, weights = Response01$weights0*Response11$weights1*Response22$weights1)
  Response35 = BestForestSplit(trainresponse, train, num.features, ntry, weights = Response01$weights1*Response12$weights0*Response23$weights0)
  Response36 = BestForestSplit(trainresponse, train, num.features, ntry, weights = Response01$weights1*Response12$weights0*Response23$weights1)
  Response37 = BestForestSplit(trainresponse, train, num.features, ntry, weights = Response01$weights1*Response12$weights1*Response24$weights0)
  Response38 = BestForestSplit(trainresponse, train, num.features, ntry, weights = Response01$weights1*Response12$weights1*Response24$weights1)
  Response41 = BestForestSplit(trainresponse, train, num.features, ntry, weights = Response01$weights0*Response11$weights0*Response21$weights0*Response31$weights0)
  Response42 = BestForestSplit(trainresponse, train, num.features, ntry, weights = Response01$weights0*Response11$weights0*Response21$weights0*Response31$weights1)
  Response43 = BestForestSplit(trainresponse, train, num.features, ntry, weights = Response01$weights0*Response11$weights1*Response21$weights1*Response32$weights0)
  Response44 = BestForestSplit(trainresponse, train, num.features, ntry, weights = Response01$weights0*Response11$weights1*Response21$weights1*Response32$weights1)
  Response45 = BestForestSplit(trainresponse, train, num.features, ntry, weights = Response01$weights0*Response11$weights0*Response22$weights0*Response33$weights0)
  Response46 = BestForestSplit(trainresponse, train, num.features, ntry, weights = Response01$weights0*Response11$weights0*Response22$weights0*Response33$weights1)
  Response47 = BestForestSplit(trainresponse, train, num.features, ntry, weights = Response01$weights0*Response11$weights1*Response22$weights1*Response34$weights0)
  Response48 = BestForestSplit(trainresponse, train, num.features, ntry, weights = Response01$weights0*Response11$weights1*Response22$weights1*Response34$weights1)
  Response49 = BestForestSplit(trainresponse, train, num.features, ntry, weights = Response01$weights1*Response12$weights0*Response23$weights0*Response35$weights0)
  Response410 = BestForestSplit(trainresponse, train, num.features, ntry, weights = Response01$weights1*Response12$weights0*Response23$weights0*Response35$weights1)
  Response411 = BestForestSplit(trainresponse, train, num.features, ntry, weights = Response01$weights1*Response12$weights1*Response23$weights1*Response36$weights0)
  Response412 = BestForestSplit(trainresponse, train, num.features, ntry, weights = Response01$weights1*Response12$weights1*Response23$weights1*Response36$weights1)
  Response413 = BestForestSplit(trainresponse, train, num.features, ntry, weights = Response01$weights1*Response12$weights0*Response24$weights0*Response37$weights0)
  Response414 = BestForestSplit(trainresponse, train, num.features, ntry, weights = Response01$weights1*Response12$weights0*Response24$weights0*Response37$weights1)
  Response415 = BestForestSplit(trainresponse, train, num.features, ntry, weights = Response01$weights1*Response12$weights1*Response24$weights1*Response38$weights0)
  Response416 = BestForestSplit(trainresponse, train, num.features, ntry, weights = Response01$weights1*Response12$weights1*Response24$weights1*Response38$weights1)
  
  Predweight01 =  as.numeric(inv.logit(Response01$fit$coefficients[1] + Response01$fit$coefficients[2]*test[,Response01$Feature]))
  Predweight11 =  as.numeric(inv.logit(Response11$fit$coefficients[1] + Response11$fit$coefficients[2]*test[,Response11$Feature]))
  Predweight12 =  as.numeric(inv.logit(Response12$fit$coefficients[1] + Response12$fit$coefficients[2]*test[,Response12$Feature]))
  Predweight21 =  as.numeric(inv.logit(Response21$fit$coefficients[1] + Response21$fit$coefficients[2]*test[,Response21$Feature]))
  Predweight22 =  as.numeric(inv.logit(Response22$fit$coefficients[1] + Response22$fit$coefficients[2]*test[,Response22$Feature]))
  Predweight23 =  as.numeric(inv.logit(Response23$fit$coefficients[1] + Response23$fit$coefficients[2]*test[,Response23$Feature]))
  Predweight24 =  as.numeric(inv.logit(Response24$fit$coefficients[1] + Response24$fit$coefficients[2]*test[,Response24$Feature]))
  Predweight31 =  as.numeric(inv.logit(Response31$fit$coefficients[1] + Response31$fit$coefficients[2]*test[,Response31$Feature]))
  Predweight32 =  as.numeric(inv.logit(Response32$fit$coefficients[1] + Response32$fit$coefficients[2]*test[,Response32$Feature]))
  Predweight33 =  as.numeric(inv.logit(Response33$fit$coefficients[1] + Response33$fit$coefficients[2]*test[,Response33$Feature]))
  Predweight34 =  as.numeric(inv.logit(Response34$fit$coefficients[1] + Response34$fit$coefficients[2]*test[,Response34$Feature]))
  Predweight35 =  as.numeric(inv.logit(Response35$fit$coefficients[1] + Response35$fit$coefficients[2]*test[,Response35$Feature]))
  Predweight36 =  as.numeric(inv.logit(Response36$fit$coefficients[1] + Response36$fit$coefficients[2]*test[,Response36$Feature]))
  Predweight37 =  as.numeric(inv.logit(Response37$fit$coefficients[1] + Response37$fit$coefficients[2]*test[,Response37$Feature]))
  Predweight38 =  as.numeric(inv.logit(Response38$fit$coefficients[1] + Response38$fit$coefficients[2]*test[,Response38$Feature]))
  Predweight41 =  as.numeric(inv.logit(Response41$fit$coefficients[1] + Response41$fit$coefficients[2]*test[,Response41$Feature]))
  Predweight42 =  as.numeric(inv.logit(Response42$fit$coefficients[1] + Response42$fit$coefficients[2]*test[,Response42$Feature]))
  Predweight43 =  as.numeric(inv.logit(Response43$fit$coefficients[1] + Response43$fit$coefficients[2]*test[,Response43$Feature]))
  Predweight44 =  as.numeric(inv.logit(Response44$fit$coefficients[1] + Response44$fit$coefficients[2]*test[,Response44$Feature]))
  Predweight45 =  as.numeric(inv.logit(Response45$fit$coefficients[1] + Response45$fit$coefficients[2]*test[,Response45$Feature]))
  Predweight46 =  as.numeric(inv.logit(Response46$fit$coefficients[1] + Response46$fit$coefficients[2]*test[,Response46$Feature]))
  Predweight47 =  as.numeric(inv.logit(Response47$fit$coefficients[1] + Response47$fit$coefficients[2]*test[,Response47$Feature]))
  Predweight48 =  as.numeric(inv.logit(Response48$fit$coefficients[1] + Response48$fit$coefficients[2]*test[,Response48$Feature]))
  Predweight49 =  as.numeric(inv.logit(Response49$fit$coefficients[1] + Response49$fit$coefficients[2]*test[,Response49$Feature]))
  Predweight410 =  as.numeric(inv.logit(Response410$fit$coefficients[1] + Response410$fit$coefficients[2]*test[,Response410$Feature]))
  Predweight411 =  as.numeric(inv.logit(Response411$fit$coefficients[1] + Response411$fit$coefficients[2]*test[,Response411$Feature]))
  Predweight412 =  as.numeric(inv.logit(Response412$fit$coefficients[1] + Response412$fit$coefficients[2]*test[,Response412$Feature]))
  Predweight413 =  as.numeric(inv.logit(Response413$fit$coefficients[1] + Response413$fit$coefficients[2]*test[,Response413$Feature]))
  Predweight414 =  as.numeric(inv.logit(Response414$fit$coefficients[1] + Response414$fit$coefficients[2]*test[,Response414$Feature]))
  Predweight415 =  as.numeric(inv.logit(Response415$fit$coefficients[1] + Response415$fit$coefficients[2]*test[,Response415$Feature]))
  Predweight416 =  as.numeric(inv.logit(Response416$fit$coefficients[1] + Response416$fit$coefficients[2]*test[,Response416$Feature]))
  
  Prediction = (1-Predweight01)*(1-Predweight11)*(1-Predweight21)*(1-Predweight31)*Predweight41 + (1-Predweight01)*(1-Predweight11)*(1-Predweight21)*Predweight31*Predweight42 + (1-Predweight01)*(1-Predweight11)*Predweight21*(1-Predweight32)*Predweight43 + (1-Predweight01)*(1-Predweight11)*Predweight21*Predweight32*Predweight44 + (1-Predweight01)*Predweight11*(1-Predweight22)*(1-Predweight33)*Predweight45 + (1-Predweight01)*Predweight11*(1-Predweight22)*Predweight33*Predweight46 + (1-Predweight01)*Predweight11*Predweight22*(1-Predweight34)*Predweight47 + (1-Predweight01)*Predweight11*Predweight22*Predweight34*Predweight48 + Predweight01*(1-Predweight12)*(1-Predweight23)*(1-Predweight35)*Predweight49 + Predweight01*(1-Predweight12)*(1-Predweight23)*Predweight35*Predweight410 + Predweight01*(1-Predweight12)*Predweight23*(1-Predweight36)*Predweight411 + Predweight01*(1-Predweight12)*Predweight23*Predweight36*Predweight412 + Predweight01*Predweight12*(1-Predweight24)*(1-Predweight37)*Predweight413 + Predweight01*Predweight12*(1-Predweight24)*Predweight37*Predweight414 + Predweight01*Predweight12*Predweight24*(1-Predweight38)*Predweight415 + Predweight01*Predweight12*Predweight24*Predweight38*Predweight416 
  
  if(keep == FALSE) return(Prediction)
  if(keep == TRUE) return(list(Prediction = Prediction, AllFeatures = cbind(Response01$Feature, Response11$Feature, Response12$Feature, Response21$Feature, Response22$Feature, Response23$Feature, Response24$Feature, Response31$Feature, Response32$Feature, Response33$Feature, Response34$Feature, Response35$Feature, Response36$Feature, Response37$Feature, Response38$Feature, Response41$Feature, Response42$Feature, Response43$Feature, Response44$Feature, Response45$Feature, Response46$Feature, Response47$Feature, Response48$Feature, Response49$Feature, Response410$Feature, Response411$Feature, Response412$Feature, Response413$Feature, Response414$Feature, Response415$Feature, Response416$Feature), AllWeights = cbind(Predweight01, Predweight11, Predweight12, Predweight21, Predweight22, Predweight23, Predweight24, Predweight31, Predweight32, Predweight33, Predweight34, Predweight35, Predweight36, Predweight37, Predweight38, Predweight41, Predweight42, Predweight43, Predweight44, Predweight45, Predweight46, Predweight47, Predweight48, Predweight49, Predweight410, Predweight411, Predweight412, Predweight413, Predweight414, Predweight415, Predweight416)))
}
