% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mainFunctions.R
\name{infoSource}
\alias{infoSource}
\title{Get summary statistics on graphs and variables}
\usage{
infoSource(sourceObj, map.name.variable = NULL, method = "fdr")
}
\arguments{
\item{sourceObj}{a \code{SourceSetObj} object, i.e. the output of the \code{\link[SourceSet]{sourceSet}} function}

\item{map.name.variable}{a list of customized labels to be associated with the names of the genes. Each list element must contain only one value (i.e. the new label), and the name of each element must be associated with the names of the genes given as input to the \code{\link[SourceSet]{sourceSet}} function (column names of \code{data} input argument). If a label is not mapped, the original name is used}

\item{method}{correction method for p-values calculated on graphs. The adjustment methods allowed are: \code{fdr} (default), \code{holm}, \code{hochberg}, \code{hommel}, \code{bonferroni}, \code{BH}, \code{BY} or \code{none}. For more details refer to \code{\link[stats]{p.adjust}}.}
}
\value{
The function guides the user in identifying interesting variables returning two objects:
\itemize{
  \item{\code{graph}: a dataframe that summirizes the results of the individual input graphs, composed as follows:
    \itemize{
      \item{\code{n.primary}: number of genes belonging to the source set;}
      \item{\code{n.secondary}: number of genes belonging to the secondary set;}
      \item{\code{n.graph}: number of genes within the graph;}
      \item{\code{n.cluster}: number of connected components of the graph;}
      \item{\code{primary.impact}: relative size of the estimated source set. This index quantifies the proportion of the graph impacted by primary dysregulation;}
      \item{\code{total.impact}: relative size of the set of genes impacted by dysregulation. This index quantifies the proportion of the graph impacted by either primary or secondary dysregulation;}
      \item{\code{adj.pvalue}: multiplicity adjusted p-value for the hypothesis of equality of the two distributions associated to the given graph}
    }}
  \item{\code{variable}: a dataframe that summarized the results of the individual variables, composed as follows:
    \itemize{
      \item{\code{n.primary}: number of input graphs in which the gene appears in the associated source set;}
      \item{\code{n.secondary}: number of input graphs in which the gene appears in the associated secondary set;}
      \item{\code{n.graph}:  number of pathways in which the gene is annotated;}
      \item{\code{specificity}: percentage of input graphs containing the given genes with respect to the total number of input graphs;}
      \item{\code{primary.impact}: percentage of input graphs, such that the given gene belongs to their estimated source set, with respect to the total number of input graphs in which the gene appears;}
      \item{\code{total.impact}: percentage of input graphs, such that the given gene is affected by some form of dysregulation in the considered graph, with respect to the total number of input graphs in which the gene appears;}
      \item{\code{relevance}: percentage of the input graphs such that the given variable belongs to their estimated source set, with respect to the total number of input graphs. It is a general measure of the importance of the gene based on the chosen pathways;}
      \item{\code{score}: a number ranging from \code{0} (low significance) to \code{+Inf} (maximal significance), computed as the combination of the p-values of all components (of all the input graphs) containing the given variable}
    }
  }
}
}
\description{
The \code{infoSource} function provides a summary of the results by focusing on either variables or graphs.
}
\note{
Ideally, variables of the primary dysregulation will be elements of the source set in all input graphs that contain them and will thus have high values of \code{source.impact} and \code{score}.
However, if a given variable appears in a single graph, and belongs to its source set, these indices can be deceptive.

For this reason, \code{relevance} serves to identify variables that apart from being good candidates for primary genes, also appear frequently in the input graphs.
Which index is to be preferred depends on the objective of the analysis: in case of exploratory analysis, we suggest to rely on \code{relevance}.
}
\examples{
## Load the SourceSetObj obtained from the source set analysis of ALL dataset

# see vignette for more details
print(load(file=system.file("extdata","ALLsourceresult.RData",package = "SourceSet")))
class(results.all)

info.all<-infoSource(sourceObj = results.all)
## results of individual input graphs
info.all$graph

## results of individual variables
# ..that appear in more than one graph and with relevance>0
info.all.genes<-info.all$variable[info.all$variable$n.graph>1 & info.all$variable$relevance>0,]
# ..ordered by score
ind.ord<-order(info.all.genes$relevance,decreasing = TRUE)
info.all.genes[ind.ord,]
}
