% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mainFunctions.R
\name{easyLookSource}
\alias{easyLookSource}
\title{Easy look results}
\usage{
easyLookSource(
  sourceObj,
  name.graphs = names(sourceObj),
  map.name.variable = NULL,
  label.variable = "Variable",
  label.graph = "Graph",
  subname.variable = 10,
  subname.graph = 20,
  maxnum.variable = 50,
  maxnum.graph = 30,
  title = "Source Set for each Pathway",
  subtitle = NULL,
  coord.equal = TRUE,
  coord.flip = FALSE,
  strsplit.variable = " ",
  strsplit.graph = " ",
  col.primary = "#324E7B",
  col.secondary = "#86A6DF"
)
}
\arguments{
\item{sourceObj}{a \code{SourceSetObj} objects, i.e. the output of the \code{\link[SourceSet]{sourceSet}} function}

\item{name.graphs}{the graphs names to be visualized. Default value is \code{names(sourceObj)}}

\item{map.name.variable}{a list of customized labels to be associated with the names of the genes. Each list element must contain only one value (i.e. the new label), and the name of each element must be associated with the names of the genes given as input to the \code{\link[SourceSet]{sourceSet}} function (column names of \code{data} input argument). If a label is not mapped, the original name is used}

\item{label.variable}{title of the variable axis}

\item{label.graph}{title of the graph axis}

\item{subname.variable}{number of characters of the variable names labels to show. The function cuts the name at the first \code{str.split} character that doesn't exceed \code{subname.variable}}

\item{subname.graph}{number of characters of the graph names labels to show. The function cuts the name at the first \code{str.split} character that doesn't exceed \code{subname.variable}}

\item{maxnum.variable}{maximal number of variables to include in the plot. The variables are sorted internally and only the first \code{maxnum.variable} are be plotted.}

\item{maxnum.graph}{maximal number of graphs to include in the plot. The graphs are sorted internally and only the first \code{maxnum.variable} are be plotted.}

\item{title}{overall title of the plot}

\item{subtitle}{subtitle of the plot}

\item{coord.equal}{if \code{TRUE}, forces the scale coordinate system to be equal for the y and x axis. See also \code{\link[ggplot2]{coord_fixed}}}

\item{coord.flip}{if \code{TRUE}, flips cartesian coordinates so that horizontal becomes vertical, and vertical, horizontal. Default option sets to x axis the variables, and to the y axis the graphs. See also \code{\link[ggplot2]{coord_flip}}}

\item{strsplit.variable}{character containing regular expression to use for cut varibale labels to be shown. More details in \code{subname.variable} and  \code{subname.variable} argument descriptions}

\item{strsplit.graph}{character containing regular expression to use for cut graph labels to be shown. More details in \code{subname.variable} and  \code{subname.variable} argument descriptions}

\item{col.primary}{cell color for the variables responsable of primary dysregulation}

\item{col.secondary}{cell color for the variables responsable of secondary dysregulation}
}
\value{
The function returns a \code{ggplot} object.
}
\description{
The function \code{easyLookSource}e allows to summarize the results obtained from the \code{\link[SourceSet]{sourceSet}} function through a heatmap, using \code{\link[ggplot2]{ggplot}} library.
}
\details{
The plot is composed of a matrix whose rows represent pathways (i.e., graphs) and columns represent genes (i.e., variables).
Each cell i, j can take one of the following configurations:
\itemize{
  \item{ \code{2}: blue color, if the i-th gene is in the primary set of the j-th pathway}
  \item{ \code{1}: light blue color, if the i-th gene is in the secondary set of the j-th pathway}
  \item{ \code{0}: gray, if the i-th gene belongs to the j-th pathway }
  \item{ \code{NA}: white, if the i-th gene does not belong to the j-th pathway}
}
In the plot, the pathways are vertically ordered - top to bottom - according to the numbers of nodes in the source set. The genes are horizontally ordered (from left to right) based on the number of times they appear in a source set.
}
\examples{
## Load the SourceSetObj obtained from the source set analysis of ALL dataset

# see vignette for more details
print(load(file=system.file("extdata","ALLsourceresult.RData",package = "SourceSet")))
class(results.all)
n.primary<-length(lapply(results.all,function(x) x$primarySet))

# show only genes that appear in at least one of the source sets of the investigated pathways
easyLookSource(sourceObj=results.all, maxnum.variable = n.primary,
               label.variable = "Genes",label.graph = "Pathways")

# flip coordinates
easyLookSource(sourceObj = results.all,maxnum.variable = n.primary,coord.flip = TRUE)
}
\seealso{
\code{\link[SourceSet]{sourceSet}}, \code{\link[SourceSet]{sourceSankeyDiagram}}
}
