% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modeling.R
\name{random_region}
\alias{random_region}
\title{Select Closest Spatial IDs to a Center Point: this is used for permutation}
\usage{
random_region(spatial_coord, center_id, n_ids)
}
\arguments{
\item{spatial_coord}{A data frame of the spatial coordinates. The column names should include `c("Spot_ID", "imagerow", "imagecol")`, and the row names must be the Spot_IDs, which is the same as the row names in the cell type proportion data frame or the column names of the gene*spot expression data frame.}

\item{center_id}{A character string specifying the ID of the center spot from which distances are calculated.}

\item{n_ids}{An integer specifying the number of closest IDs to select.}
}
\value{
A character vector of the `n_ids` closest IDs to the specified center ID.
}
\description{
This function identifies and returns the IDs of the closest spatial points to a specified center point based on Euclidean distance.
}
\examples{
\donttest{
spatial_coord <- data.frame(
  imagecol = c(1, 2, 3, 4, 5),
  imagerow = c(5, 4, 3, 2, 1),
  row.names = c("Spot1", "Spot2", "Spot3", "Spot4", "Spot5")
)
center_id <- "Spot3"
closest_ids <- random_region(spatial_coord, center_id, 3)
print(closest_ids)
}
}
