% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moduleMetadata.R
\docType{methods}
\name{moduleMetadata}
\alias{moduleMetadata}
\alias{moduleMetadata,character,character,missing-method}
\alias{moduleMetadata,character,missing,missing-method}
\alias{moduleMetadata,ANY,missing,simList-method}
\title{Parse and extract module metadata}
\usage{
moduleMetadata(module, path, sim)

\S4method{moduleMetadata}{character,character,missing}(module, path)

\S4method{moduleMetadata}{character,missing,missing}(module)

\S4method{moduleMetadata}{ANY,missing,simList}(module, sim)
}
\arguments{
\item{module}{Character string. Your module's name.}

\item{path}{Character string specifying the file path to modules directory.
Default is to use the \code{spades.modulePath} option.}

\item{sim}{A \code{simList} simulation object, generally produced by \code{simInit}.}
}
\value{
A list of module metadata, matching the structure in
        \code{\link{defineModule}}.
}
\description{
Parse and extract module metadata
}
\examples{
path <- system.file("sampleModules", package = "SpaDES.core")
sampleModules <- dir(path)
x <- moduleMetadata(sampleModules[3], path)

# using simList
mySim <- simInit(
   times = list(start = 2000.0, end = 2002.0, timeunit = "year"),
   params = list(
     .globals = list(stackName = "landscape", burnStats = "nPixelsBurned")
   ),
   modules = list("randomLandscapes", "fireSpread", "caribouMovement"),
   paths = list(modulePath = system.file("sampleModules", package = "SpaDES.core"))
)
moduleMetadata(sim = mySim)
}
\seealso{
\code{\link{defineModule}}
}
\author{
Alex Chubaty
}
