% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/downloadData.R
\name{downloadData}
\alias{downloadData}
\alias{downloadData,character,character,logical-method}
\alias{downloadData,character,missing,missing-method}
\alias{downloadData,character,missing,logical-method}
\alias{downloadData,character,character,missing-method}
\title{Download module data}
\usage{
downloadData(
  module,
  path,
  quiet,
  quickCheck = FALSE,
  overwrite = FALSE,
  files = NULL,
  checked = NULL,
  urls = NULL,
  children = NULL,
  ...
)

\S4method{downloadData}{character,character,logical}(
  module,
  path,
  quiet,
  quickCheck = FALSE,
  overwrite = FALSE,
  files = NULL,
  checked = NULL,
  urls = NULL,
  children = NULL,
  ...
)

\S4method{downloadData}{character,missing,missing}(module, quickCheck, overwrite, files, checked, urls, children)

\S4method{downloadData}{character,missing,logical}(
  module,
  quiet,
  quickCheck,
  overwrite,
  files,
  checked,
  urls,
  children
)

\S4method{downloadData}{character,character,missing}(
  module,
  path,
  quickCheck,
  overwrite,
  files,
  checked,
  urls,
  children
)
}
\arguments{
\item{module}{Character string giving the name of the module.}

\item{path}{Character string giving the path to the module directory.}

\item{quiet}{Logical. This is passed to \code{download.file}. Default is FALSE.}

\item{quickCheck}{Logical. If \code{TRUE}, then the check with local data will only
use \code{file.size} instead of \code{digest::digest}.
This is faster, but potentially much less robust.}

\item{overwrite}{Logical. Should local data files be overwritten in case they exist?
Default is \code{FALSE}.}

\item{files}{A character vector of length 1 or more if only a subset of files should be
checked in the \file{CHECKSUMS.txt} file.}

\item{checked}{The result of a previous \code{checksums} call. This should only be used when
there is no possibility that the file has changed, i.e., if \code{downloadData} is
called from inside another function.}

\item{urls}{Character vector of urls from which to get the data. This is automatically
found from module metadata when this function invoked with
\code{SpaDES.core::downloadModule(..., data = TRUE)}. See also
\code{\link{prepInputs}}.}

\item{children}{The character vector of child modules (without path) to also
run \code{downloadData} on}

\item{...}{Passed to \code{\link[reproducible]{preProcess}}, e.g., \code{purge}}
}
\value{
Invisibly, a list of downloaded files.
}
\description{
Download external data for a module if not already present in the module
directory, or if there is a checksum mismatch indicating that the file is not
the correct one.
}
\details{
\code{downloadData} requires a checksums file to work, as it will only download
the files specified therein. Hence, module developers should make sure they
have manually downloaded all the necessary data and ran \code{checksums} to
build a checksums file.

There is an experimental attempt to use the \pkg{googledrive} package to download
data from a shared (publicly or with individual users) file.
To try this, put the Google Drive URL in \code{sourceURL} argument of
\code{expectsInputs} in the module metadata, and put the filename once downloaded
in the \code{objectName} argument.
If using RStudio Server, you may need to use "out of band" authentication by
setting \code{options(httr_oob_default = TRUE)}.
To avoid caching of Oauth credentials, set \code{options(httr_oauth_cache = TRUE)}.

There is also an experimental option for the user to make a new \file{CHECKSUMS.txt}
file if there is a \code{sourceURL} but no entry for that file.
This is experimental and should be used with caution.
}
\examples{
\dontrun{
# For a Google Drive example
# In metadata:
expectsInputs("theFilename.zip", "NA", "NA",
  sourceURL = "https://drive.google.com/open?id=1Ngb-jIRCSs1G6zcuaaCEFUwldbkI_K8Ez")
# create the checksums file
checksums("thisModule", "there", write = TRUE)
downloadData("thisModule", "there", files = "theFilename.zip")
}

}
\seealso{
\code{\link{prepInputs}}, \code{\link{checksums}}, and \code{\link{downloadModule}}
for downloading modules and building a checksums file.
}
\author{
Alex Chubaty & Eliot McIntire
}
