% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation-spades.R
\name{scheduleEvent}
\alias{scheduleEvent}
\title{Schedule a simulation event}
\usage{
scheduleEvent(
  sim,
  eventTime,
  moduleName,
  eventType,
  eventPriority = .pkgEnv$.normalVal,
  .skipChecks = FALSE
)
}
\arguments{
\item{sim}{A \code{simList} simulation object.}

\item{eventTime}{A numeric specifying the time of the next event.}

\item{moduleName}{A character string specifying the module from which to
call the event. If missing, it will use
\code{currentModule(sim)}}

\item{eventType}{A character string specifying the type of event from
within the module.}

\item{eventPriority}{A numeric specifying the priority of the event.
Lower number means higher priority. As a best practice, it is
recommended that decimal values are conceptual
grouped by their integer values (e.g., 4.0, 4.25, 4.5 are conceptually
similar).
See \code{\link[=priority]{priority()}}.}

\item{.skipChecks}{Logical. If \code{TRUE}, then internal checks that arguments match
expected types are skipped. Should only be used if speed is critical.}
}
\value{
Returns the modified \code{simList} object.
}
\description{
Adds a new event to the simulation's event queue, updating the simulation object.
}
\details{
Here, we implement a simulation in a more modular fashion so it's easier to add
submodules to the simulation. We use S4 classes and methods, and use \code{data.table}
instead of \code{data.frame} to implement the event queue (because it is much faster).
}
\examples{
\dontrun{
 scheduleEvent(x, time(sim) + 1.0, "firemodule", "burn") # default priority
 scheduleEvent(x, time(sim) + 1.0, "firemodule", "burn", .normal()) # default priority

 scheduleEvent(x, time(sim) + 1.0, "firemodule", "burn", .normal()-1) # higher priority
 scheduleEvent(x, time(sim) + 1.0, "firemodule", "burn", .normal()+1) # lower priority

 scheduleEvent(x, time(sim) + 1.0, "firemodule", "burn", .highest()) # highest priority
 scheduleEvent(x, time(sim) + 1.0, "firemodule", "burn", .lowest()) # lowest priority
}
}
\references{
Matloff, N. (2011). The Art of R Programming (ch. 7.8.3).
San Francisco, CA: No Starch Press, Inc..
Retrieved from \url{https://nostarch.com/artofr.htm}
}
\seealso{
\code{\link[=priority]{priority()}}, \code{\link[=scheduleConditionalEvent]{scheduleConditionalEvent()}}
}
\author{
Alex Chubaty
}
