% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/module-template.R
\name{newModuleDocumentation}
\alias{newModuleDocumentation}
\alias{newModuleDocumentation,character,character-method}
\alias{newModuleDocumentation,character,missing-method}
\title{Create new module documentation}
\usage{
newModuleDocumentation(name, path, ...)

\S4method{newModuleDocumentation}{character,character}(name, path, ...)

\S4method{newModuleDocumentation}{character,missing}(name, path, ...)
}
\arguments{
\item{name}{Character string specifying the name of the new module.}

\item{path}{Character string. Subdirectory in which to place the new module code file.
The default is the current working directory.}

\item{...}{Additional arguments. Currently, these can be either named
function definitions (which will be added to the \code{simList}) or one or
more of the following:\cr\cr
\describe{
\item{\code{children}}{Required when \code{type = "parent"}. A character vector
specifying the names of child modules.}
\item{\code{open}}{Logical. Should the new module file be opened after creation?
Default \code{TRUE}.}
\item{\code{type}}{Character string specifying one of \code{"child"} (default),
or \code{"parent"}.}
}}
}
\value{
NULL (invisibly). Invoked for its side effect of creating new module code files.
}
\description{
Create new module documentation
}
\seealso{
Other module creation helpers: 
\code{\link{newModule}()},
\code{\link{newModuleCode}()},
\code{\link{newModuleTests}()}
}
\author{
Eliot McIntire and Alex Chubaty
}
\concept{module creation helpers}
