% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initialize.R
\docType{methods}
\name{randomPolygons}
\alias{randomPolygons}
\alias{randomPolygon}
\alias{randomPolygon.default}
\title{Produce a \code{SpatRaster} of  random polygons}
\usage{
randomPolygons(
  ras = rast(ext(0, 15, 0, 15), res = 1, vals = 0),
  numTypes = 2,
  ...
)

randomPolygon(x, hectares, area)

\method{randomPolygon}{default}(x, hectares, area)
}
\arguments{
\item{ras}{A raster that whose extent will be used for the random polygons.}

\item{numTypes}{Numeric value. The number of unique polygon types to use.}

\item{...}{Other arguments passed to \code{spread}. No known uses currently.}

\item{x}{Either a \code{SpatVector}, or \code{SpatialPoints} (deprecated), \code{SpatialPolygons}
(deprecated), or \code{matrix} with two
dimensions, 1 row, with the approximate centre of the new random polygon to create.
If \code{matrix}, then longitude and latitude are assumed (epsg:4326)}

\item{hectares}{Deprecated. Use \code{area} in meters squared.}

\item{area}{A numeric, the approximate area in \verb{meters squared} of the random polygon.}
}
\value{
A map of extent \code{ext} with random polygons.

A \code{SpatVector} polygons object, with approximately the area request,
centred approximately at the coordinates requested, in the projection of \code{x}
}
\description{
These are built with the \code{\link[=spread]{spread()}} function internally.

Produces a \code{SpatVector} polygons object with 1 feature that will have approximately an area
equal to \code{area} (expecting area in hectares), #' and a centre at approximately \code{x}.
}
\examples{
origDTThreads <- data.table::setDTthreads(2L)
origNcpus <- options(Ncpus = 2L)

set.seed(1234)
Ras <- randomPolygons(numTypes = 5)
if (interactive() ) {
  terra::plot(Ras, col = c("yellow", "dark green", "blue", "dark red"))
}

# more complex patterning, with a range of patch sizes
r <- terra::rast(terra::ext(0, 50, 0, 50), resolution = 1, vals = 0)
a <- randomPolygons(numTypes = 400, r)
a[a < 320] <- 0
a[a >= 320] <- 1
clumped <- terra::patches(a)
if (interactive()) {
  terra::plot(a)
}

# clean up
data.table::setDTthreads(origDTThreads)
options(Ncpus = origNcpus)

library(terra)
b <- terra::vect(cbind(-110, 59), crs = "epsg:4326")
a <- randomPolygon(b, area = 1e6)
if (interactive()) {
  plot(a)
  points(b, pch = 19)
}

}
\seealso{
\code{\link[=spread]{spread()}}, \code{\link[=randomPolygons]{randomPolygons()}}
}
