% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/moduleMetadata.R
\docType{methods}
\name{moduleMetadata}
\alias{moduleMetadata}
\alias{moduleMetadata,character,character-method}
\alias{moduleMetadata,character,missing-method}
\title{Parse and extract module metadata}
\usage{
moduleMetadata(module, path)

\S4method{moduleMetadata}{character,character}(module, path)

\S4method{moduleMetadata}{character,missing}(module)
}
\arguments{
\item{module}{Character string. Your module's name.}

\item{path}{Character string specifying the file path to modules directory.
              Default is the current working directory.}
}
\value{
A list of module metadata, matching the structure in
        \code{\link{defineModule}}.
}
\description{
Parse and extract module metadata
}
\examples{
path <- system.file(package="SpaDES", "sampleModules")
  sampleModules <- dir(path)
  x <- moduleMetadata(sampleModules[1], path)
}
\author{
Alex Chubaty
}
\seealso{
\code{\link{defineModule}}
}

