% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simList-accessors.R
\docType{methods}
\name{objs}
\alias{$}
\alias{$,simList-method}
\alias{$<-}
\alias{$<-,simList-method}
\alias{[[}
\alias{[[,simList,ANY,ANY-method}
\alias{[[<-}
\alias{[[<-,simList,ANY,ANY,ANY-method}
\alias{objs}
\alias{objs,simList-method}
\alias{objs<-}
\alias{objs<-,simList-method}
\alias{simList-accessors-objects}
\title{Extract or replace an object from the simulation environment}
\usage{
objs(x, ...)

\S4method{objs}{simList}(x, ...)

objs(x) <- value

\S4method{objs}{simList}(x) <- value

\S4method{[[}{simList,ANY,ANY}(x, i, j, ..., drop)

\S4method{[[}{simList,ANY,ANY,ANY}(x, i) <- value

\S4method{$}{simList}(x, name)

\S4method{$}{simList}(x, name) <- value
}
\arguments{
\item{x}{A \code{simList} object from which to extract element(s) or
in which to replace element(s).}

\item{...}{see \code{i}.}

\item{value}{Any R object.}

\item{i}{Indices specifying elements to extract or replace.}

\item{j}{see \code{i}.}

\item{drop}{not implemented.}

\item{name}{A literal character string or a \code{\link{name}}.}
}
\value{
Returns or sets a list of objects in the \code{simList} environment.
}
\description{
The \code{[[} and \code{$} operators provide "shortcuts" for accessing
objects in the simulation environment.
I.e., instead of using \code{envir(sim)$object} or \code{envir(sim)[["object"]]},
one can simply use \code{sim$object} or \code{sim[["object"]]}.
}
\details{
\code{objs} can take \code{...} arguments passed to \code{ls},
allowing, e.g. \code{all.names=TRUE}
\code{objs<-} requires takes a named list of values to be assigned in
the simulation envirment.
}
\seealso{
\code{\link[SpaDES]{ls-method}},
         \code{\link[SpaDES]{ls_str-method}},
         \code{\link{simList-class}},
         \code{\link{simList-accessors-envir}},
         \code{\link{simList-accessors-events}},
         \code{\link{simList-accessors-inout}},
         \code{\link{simList-accessors-modules}},
         \code{\link{simList-accessors-params}},
         \code{\link{simList-accessors-paths}},
         \code{\link{simList-accessors-times}}.
}

