% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/times.R
\docType{methods}
\name{inSeconds}
\alias{.spadesTimes}
\alias{convertTimeunit}
\alias{convertTimeunit,numeric,character-method}
\alias{convertTimeunit,numeric,missing-method}
\alias{inSeconds}
\alias{inSeconds,NULL-method}
\alias{inSeconds,character-method}
\alias{spadesTimes}
\title{Convert time units}
\format{An object of class \code{character} of length 6.}
\usage{
inSeconds(unit)

\S4method{inSeconds}{character}(unit)

\S4method{inSeconds}{`NULL`}(unit)

convertTimeunit(time, unit)

\S4method{convertTimeunit}{numeric,character}(time, unit)

\S4method{convertTimeunit}{numeric,missing}(time)

.spadesTimes

spadesTimes()
}
\arguments{
\item{unit}{Character. One of the time units used in \code{SpaDES}.}

\item{time}{Numeric. With a unit attribute, indicating the time unit of the
input numeric. See Details.}
}
\value{
A numeric vector of length 1, with \code{unit} attribute set to
"seconds".
}
\description{
In addition to using the \code{lubridate} package, some additional functions
to work with times are provided.

This function takes a numeric with a "unit" attribute and converts it to
another numeric with a different time attribute.
If the units passed to argument \code{units} are the same as
\code{attr(time, "unit")}, then it simply returns input \code{time}.
}
\details{
Currently available units are found within the \code{spadesTimes()} function.

If \code{time} has no \code{units} attribute, then it is assumed to be
seconds.
}
\author{
Alex Chubaty & Eliot McIntire

Eliot McIntire
}
\keyword{datasets}

