% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.R
\docType{methods}
\name{spades}
\alias{spades}
\alias{spades,simList,logical-method}
\alias{spades,simList,missing-method}
\title{Run a spatial discrete event simulation}
\usage{
spades(sim, debug)

\S4method{spades}{simList,logical}(sim, debug)

\S4method{spades}{simList,missing}(sim)
}
\arguments{
\item{sim}{A \code{simList} simulation object, generally produced by \code{simInit}.}

\item{debug}{Optional logical flag determines whether sim debug info
will be printed (default is \code{debug=FALSE}).}
}
\value{
Invisibly returns the modified \code{simList} object.
}
\description{
Based on code from chapter 7.8.3 of Matloff (2011): "Discrete event simulation".
Here, we implement a simulation in a more modular fashion so it's easier to add
submodules to the simulation. We use S4 classes and methods, and use `data.table`
instead of `data.frame` to implement the event queue (because it is much faster).
}
\note{
The debug option is primarily intended to facilitate building simulation
models by the user. Will print additional outputs informing the user of updates
to the values of various simList slot components.
}
\examples{
\dontrun{
 mySim <- simInit(
   times = list(start = 0.0, end = 2.0, timeunit = "year"),
   params = list(
     .globals = list(stackName = "landscape", burnStats = "nPixelsBurned"),
     fireSpread = list(.plotInitialTime=NA),
     randomLandscapes = list(.plotInitialTime=NA),
     caribouMovement = list(.plotInitialTime=NA)
   ),
   modules = list("randomLandscapes", "fireSpread", "caribouMovement"),
   paths = list(modulePath = system.file("sampleModules", package = "SpaDES"))
 )
 spades(mySim)
}

}
\author{
Alex Chubaty
}
\references{
Matloff, N. (2011). The Art of R Programming (ch. 7.8.3). San Fransisco, CA: No Starch Press, Inc.. Retrieved from \url{https://www.nostarch.com/artofr.htm}
}
\seealso{
\code{\link{simInit}}, \code{\link{SpaDES}}
}

