% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simList-accessors.R
\docType{methods}
\name{paths}
\alias{cachePath}
\alias{cachePath,.simList-method}
\alias{cachePath<-}
\alias{cachePath<-,.simList-method}
\alias{inputPath}
\alias{inputPath,.simList-method}
\alias{inputPath<-}
\alias{inputPath<-,.simList-method}
\alias{modulePath}
\alias{modulePath,.simList-method}
\alias{modulePath<-}
\alias{modulePath<-,.simList-method}
\alias{outputPath}
\alias{outputPath,.simList-method}
\alias{outputPath<-}
\alias{outputPath<-,.simList-method}
\alias{paths}
\alias{paths,.simList-method}
\alias{paths<-}
\alias{paths<-,.simList-method}
\alias{simList-accessors-paths}
\title{Specify paths for modules, inputs, and outputs}
\usage{
paths(object)

\S4method{paths}{.simList}(object)

paths(object) <- value

\S4method{paths}{.simList}(object) <- value

cachePath(object)

\S4method{cachePath}{.simList}(object)

cachePath(object) <- value

\S4method{cachePath}{.simList}(object) <- value

inputPath(object)

\S4method{inputPath}{.simList}(object)

inputPath(object) <- value

\S4method{inputPath}{.simList}(object) <- value

outputPath(object)

\S4method{outputPath}{.simList}(object)

outputPath(object) <- value

\S4method{outputPath}{.simList}(object) <- value

modulePath(object)

\S4method{modulePath}{.simList}(object)

modulePath(object) <- value

\S4method{modulePath}{.simList}(object) <- value
}
\arguments{
\item{object}{A \code{simList} simulation object.}

\item{value}{The object to be stored at the slot.}
}
\value{
Returns or sets the value of the slot from the \code{simList} object.
}
\description{
Accessor functions for the \code{paths} slot in a \code{simList} object.
}
\details{
These are ways to add or access the file paths used by \code{\link{spades}}.
There are four file paths: \code{cachePath}, \code{modulePath},
\code{inputPath}, and \code{outputPath}.
Each has a function to get or set the value in a \code{simList} object.
If no paths are specified, the defaults are as follows:

\itemize{
  \item \code{cachePath}: a subdirectory of the current working directory (\code{"./cache"});

\item \code{inputPath}: the current working directory (\code{"."};

\item \code{modulePath}: \code{getOption("spades.modulePath")};

\item \code{inputPath}: the current working directory (\code{"."};
}
}
\seealso{
\code{\link{SpaDES}}, specifically the section 1.2.4 on Simulation Paths.

Other functions to access elements of a \code{simList} object: \code{\link{.addDepends}},
  \code{\link{doEvent.checkpoint}}, \code{\link{envir}},
  \code{\link{events}}, \code{\link{globals}},
  \code{\link{inputs}}, \code{\link{ls.simList}},
  \code{\link{ls.str.simList}}, \code{\link{modules}},
  \code{\link{objs}}, \code{\link{packages}},
  \code{\link{params}}, \code{\link{progressInterval}},
  \code{\link{times}}
}

