% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/functions.R
\docType{methods}
\name{last}
\alias{last}
\alias{last}
\alias{last,characterOrColumn-method}
\title{last}
\usage{
last(x, ...)

\S4method{last}{characterOrColumn}(x, na.rm = FALSE)
}
\arguments{
\item{x}{column to compute on.}

\item{...}{further arguments to be passed to or from other methods.}

\item{na.rm}{a logical value indicating whether NA values should be stripped
before the computation proceeds.}
}
\description{
Aggregate function: returns the last value in a group.
}
\details{
The function by default returns the last values it sees. It will return the last non-missing
value it sees when na.rm is set to true. If all values are missing, then NA is returned.
}
\note{
last since 1.4.0
}
\examples{
\dontrun{
last(df$c)
last(df$c, TRUE)
}
}
\seealso{
Other agg_funcs: \code{\link{agg}}, \code{\link{avg}},
  \code{\link{countDistinct}}, \code{\link{count}},
  \code{\link{first}}, \code{\link{kurtosis}},
  \code{\link{max}}, \code{\link{mean}}, \code{\link{min}},
  \code{\link{sd}}, \code{\link{skewness}},
  \code{\link{stddev_pop}}, \code{\link{stddev_samp}},
  \code{\link{sumDistinct}}, \code{\link{sum}},
  \code{\link{var_pop}}, \code{\link{var_samp}},
  \code{\link{var}}
}
