% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/functions.R
\docType{methods}
\name{translate}
\alias{translate}
\alias{translate}
\alias{translate,Column,character,character-method}
\title{translate}
\usage{
translate(x, matchingString, replaceString)

\S4method{translate}{Column,character,character}(x, matchingString,
  replaceString)
}
\arguments{
\item{x}{a string Column.}

\item{matchingString}{a source string where each character will be translated.}

\item{replaceString}{a target string where each \code{matchingString} character will
be replaced by the character in \code{replaceString}
at the same location, if any.}
}
\description{
Translate any character in the src by a character in replaceString.
The characters in replaceString is corresponding to the characters in matchingString.
The translate will happen when any character in the string matching with the character
in the matchingString.
}
\note{
translate since 1.5.0
}
\examples{
\dontrun{translate(df$c, 'rnlt', '123')}
}
\seealso{
Other string_funcs: \code{\link{ascii}},
  \code{\link{base64}}, \code{\link{concat_ws}},
  \code{\link{concat}}, \code{\link{decode}},
  \code{\link{encode}}, \code{\link{format_number}},
  \code{\link{format_string}}, \code{\link{initcap}},
  \code{\link{instr}}, \code{\link{length}},
  \code{\link{levenshtein}}, \code{\link{locate}},
  \code{\link{lower}}, \code{\link{lpad}},
  \code{\link{ltrim}}, \code{\link{regexp_extract}},
  \code{\link{regexp_replace}}, \code{\link{reverse}},
  \code{\link{rpad}}, \code{\link{rtrim}},
  \code{\link{soundex}}, \code{\link{substring_index}},
  \code{\link{trim}}, \code{\link{unbase64}},
  \code{\link{upper}}
}
