% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/mllib_recommendation.R
\docType{methods}
\name{spark.als}
\alias{spark.als}
\alias{spark.als}
\alias{spark.als,SparkDataFrame-method}
\alias{summary,ALSModel-method}
\alias{predict,ALSModel-method}
\alias{write.ml,ALSModel,character-method}
\title{Alternating Least Squares (ALS) for Collaborative Filtering}
\usage{
spark.als(data, ...)

\S4method{spark.als}{SparkDataFrame}(data, ratingCol = "rating",
  userCol = "user", itemCol = "item", rank = 10, regParam = 0.1,
  maxIter = 10, nonnegative = FALSE, implicitPrefs = FALSE, alpha = 1,
  numUserBlocks = 10, numItemBlocks = 10, checkpointInterval = 10,
  seed = 0)

\S4method{summary}{ALSModel}(object)

\S4method{predict}{ALSModel}(object, newData)

\S4method{write.ml}{ALSModel,character}(object, path, overwrite = FALSE)
}
\arguments{
\item{data}{a SparkDataFrame for training.}

\item{...}{additional argument(s) passed to the method.}

\item{ratingCol}{column name for ratings.}

\item{userCol}{column name for user ids. Ids must be (or can be coerced into) integers.}

\item{itemCol}{column name for item ids. Ids must be (or can be coerced into) integers.}

\item{rank}{rank of the matrix factorization (> 0).}

\item{regParam}{regularization parameter (>= 0).}

\item{maxIter}{maximum number of iterations (>= 0).}

\item{nonnegative}{logical value indicating whether to apply nonnegativity constraints.}

\item{implicitPrefs}{logical value indicating whether to use implicit preference.}

\item{alpha}{alpha parameter in the implicit preference formulation (>= 0).}

\item{numUserBlocks}{number of user blocks used to parallelize computation (> 0).}

\item{numItemBlocks}{number of item blocks used to parallelize computation (> 0).}

\item{checkpointInterval}{number of checkpoint intervals (>= 1) or disable checkpoint (-1).
Note: this setting will be ignored if the checkpoint directory is not
set.}

\item{seed}{integer seed for random number generation.}

\item{object}{a fitted ALS model.}

\item{newData}{a SparkDataFrame for testing.}

\item{path}{the directory where the model is saved.}

\item{overwrite}{logical value indicating whether to overwrite if the output path
already exists. Default is FALSE which means throw exception
if the output path exists.}
}
\value{
\code{spark.als} returns a fitted ALS model.

\code{summary} returns summary information of the fitted model, which is a list.
        The list includes \code{user} (the names of the user column),
        \code{item} (the item column), \code{rating} (the rating column), \code{userFactors}
        (the estimated user factors), \code{itemFactors} (the estimated item factors),
        and \code{rank} (rank of the matrix factorization model).

\code{predict} returns a SparkDataFrame containing predicted values.
}
\description{
\code{spark.als} learns latent factors in collaborative filtering via alternating least
squares. Users can call \code{summary} to obtain fitted latent factors, \code{predict}
to make predictions on new data, and \code{write.ml}/\code{read.ml} to save/load fitted models.
}
\details{
For more details, see
\href{http://spark.apache.org/docs/latest/ml-collaborative-filtering.html}{MLlib:
Collaborative Filtering}.
}
\note{
spark.als since 2.1.0

summary(ALSModel) since 2.1.0

predict(ALSModel) since 2.1.0

write.ml(ALSModel, character) since 2.1.0
}
\examples{
\dontrun{
ratings <- list(list(0, 0, 4.0), list(0, 1, 2.0), list(1, 1, 3.0), list(1, 2, 4.0),
                list(2, 1, 1.0), list(2, 2, 5.0))
df <- createDataFrame(ratings, c("user", "item", "rating"))
model <- spark.als(df, "rating", "user", "item")

# extract latent factors
stats <- summary(model)
userFactors <- stats$userFactors
itemFactors <- stats$itemFactors

# make predictions
predicted <- predict(model, df)
showDF(predicted)

# save and load the model
path <- "path/to/model"
write.ml(model, path)
savedModel <- read.ml(path)
summary(savedModel)

# set other arguments
modelS <- spark.als(df, "rating", "user", "item", rank = 20,
                    regParam = 0.1, nonnegative = TRUE)
statsS <- summary(modelS)
}
}
\seealso{
\link{read.ml}
}
