% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shannon.R
\name{shannonZ}
\alias{shannonZ}
\title{Shannon's entropy of the transformed variable \eqn{Z}.}
\usage{
shannonZ(data, missing.cat = NULL)
}
\arguments{
\item{data}{A data matrix or vector, can be numeric, factor, character, ...
If the dataset is a point pattern, \code{data} is the mark vector.}

\item{missing.cat}{Optional, a vector with the names of all categories that are absent in \code{data}.}
}
\value{
Estimated probabilities for all \eqn{Z} categories (data pairs), and Shannon's entropy of \eqn{Z}.
}
\description{
This function computes Shannon's entropy of variable \eqn{Z},
where \eqn{Z} identifies pairs of realizations of the variable of interest.
}
\details{
Many spatial entropy indices are based on the trasformation \eqn{Z} of the study variable,
i.e. on pairs (unordered couples) of realizations of the variable of interest. 'Unordered couples'
means that the relative spatial location is irrelevant, i.e. that a couple
where category \eqn{i} occurs at the left of category \eqn{j} is identical to a couple
where category \eqn{j} occurs at the left of category \eqn{i}.
When all possible pairs occurring within the observation areas are considered,
Shannon's entropy of the variable \eqn{Z} may be computed as
\deqn{H(Z)=\sum p(z_r)\log(1/p(z_r))}
where \eqn{p(z_r)} is the probability of the \eqn{r}-th pair of realizations, here
estimated by its relative frequency.
Shannon's entropy of \eqn{Z} varies between 0 and \eqn{\log(R)}, \eqn{R} being the
number of possible pairs of categories of the variable under study.
}
\examples{
#NON SPATIAL DATA
shannonZ(sample(1:5, 50, replace=TRUE))

#POINT DATA
data.pp=runifpoint(100, win=square(10))
marks(data.pp)=sample(c("a","b","c"), 100, replace=TRUE)
shannonZ(marks(data.pp))

#LATTICE DATA
data.lat=matrix(sample(c("a","b","c"), 100, replace=TRUE), nrow=10)
shannonZ(data.lat)

#when categories are missing
shannonZ(data.lat, missing.cat=c("d", "e"))

}
