% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{raintreesCOV}
\alias{raintreesCOV}
\title{Covariates for the rainforest tree data.}
\format{
A \code{list} of two elements:
\describe{
\item{elev}{An object of type \code{im} (see package \code{spatstat}), the soil elevation}
\item{grad}{An object of type \code{im} (see package \code{spatstat}), the soil slope (gradient of elevation)}
}
}
\source{
http://www.ctfs.si.edu
}
\usage{
raintreesCOV
}
\description{
A list of two pixel images with covariates altitude and soil slope for the rainforest tree data 1 and 2,
i.e. \link{raintrees} and \link{raintrees2}
}
\details{
For details of the point datasets, see \link{raintrees} and \link{raintrees2}. This accompanying dataset
gives information about the elevation in the study region.
It is a list containing two pixel images, elev (elevation in metres)
and grad (norm of elevation gradient). These pixel images are objects of class \code{im}.
Covariate values are continuous. Once discretized as wished, they can turn into categorical datasets
for the computation of all entropy measures. Moreover, they can be used
to build sensible sub-areas for Batty's and Karlstrom and Ceccato's entropies
(see the examples).
}
\examples{
data(raintreesCOV)
plot(raintreesCOV, main="")

}
\keyword{datasets}
