% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{stprod}
\alias{stprod}
\title{Standardize a symmetric matrix (distances) to fixed row (column) products}
\usage{
stprod(mat, con, differ = 1e-15, niter = 1000L)
}
\arguments{
\item{mat}{A distance matrix size NxN.}

\item{con}{A vector of row (column) constraints.}

\item{differ}{A scalar with the maximum accepted difference with the constraint (default = 1e-15).}

\item{niter}{An integer with the maximum number of iterations (default = 1000).}
}
\value{
Returns a standardized distance matrix of size NxN.
}
\description{
Standardizes a distance matrix to fixed rows and columns
products. The function iteratively constrains a logarithmic transformed
matrix to know products, and in order to keep the symmetry of the matrix,
at each iteration performs an average with its transpose. When the known
products are all equal to a constant (e.g. 0), this method provides a
simple and accurate way to scale a distance matrix to a doubly stochastic
matrix.
}
\details{
The standardized matrix will not be affected by problems arising from units
with different inclusion probabilities caused by undesired features of the
spatial distribution of the population, as edge effects and/or isolated
points.
}
\examples{
\dontshow{
d <- matrix(runif(200), 100, 2)
dis <- as.matrix(dist(d))
con <- rep(0, nrow(dis))
stand_dist <- stprod(mat = dis, con = con)
}
\donttest{
dis <- as.matrix(dist(cbind(simul1$x, simul1$y))) # distance matrix
con <- rep(0, nrow(dis)) # vector of constraints
stand_dist <- stprod(mat = dis, con = con) # standardized matrix
}
}
\references{
Benedetti R, Piersimoni F (2017). A spatially balanced design with
probability function proportional to the within sample distance.
\emph{Biometrical Journal}, \strong{59}(5), 1067-1084.
\url{https://doi.org/10.1002/bimj.201600194}
}
