% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrwd.R
\name{mrwd}
\alias{mrwd}
\title{Fit a Multivariate Random Walk with Drift}
\usage{
mrwd(x)
}
\arguments{
\item{x}{numeric matrix with a multivariate time series.
Series are arranged in rows with columns representing time.}
}
\value{
an object of class \code{"mrwd"} with components:
\item{drift}{ a vector with the estimated drift.}
\item{sigma}{ a matrix with the estimated variance covariance 
 matrix.}
\item{fitted}{ fitted values.}
\item{residuals}{ residuals from the fitted model. That is 
observed minus fitted values.}
\item{x}{the original time series.}
}
\description{
Fits a Multivariate Random Walk with Drift to \code{x}, a
multivariate time series.
}
\details{
For further information on the Multivariate Random Walk with
drift see Appendix B in Haberman and Renshaw (2011).
}
\references{
Haberman, S., & Renshaw, A. (2011). A comparative study of parametric 
mortality projection models. Insurance: Mathematics and Economics, 
48(1), 35-55.
}

