% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qqnormSim.R
\docType{methods}
\name{qqnormSim}
\alias{qqnormSim}
\alias{qqnormSim,lm-method}
\alias{qqnormSim,numeric-method}
\title{Plots a QQ-Norm plot with several Gaussian simulations.}
\usage{
qqnormSim(x, nSim = 500)

\S4method{qqnormSim}{lm}(x, nSim = 500)

\S4method{qqnormSim}{numeric}(x, nSim = 500)
}
\arguments{
\item{x}{is a lm-object or a numeric vector. If it's a lm-object its residuals are plotted.}

\item{nSim}{is an optional argument. If you like to have more or less than 500 simulations you can specify this parameter.}
}
\value{
invisible(NULL)
}
\description{
Plots a QQ-Norm plot of the variable x with nSim Gaussian simulations.
}
\examples{
\dontrun{
# The observations should behave like a simulation, 
# because the observations are sampled from a Gaussian distribution.
qqnormSim(rnorm(100))
# On the first glance its obvious that this sample 
# doesn't originate from a Gaussian distribution due to the heavy tails.
qqnormSim(rt(100,df = 4))

Reduce the simulation tracks from 500 to 50. (500 is default).
Not recommended unless you have not enough computation power.
qqnormSim(rnorm(100), nSim = 50)
}
}
\author{
Matthias Salvisberg <matthias.salvisberg@gmail.com>
}
\keyword{qqnorm}
