% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/iv.R
\name{iv}
\alias{iv}
\title{Information value of an independent variable in predicting a binary response}
\usage{
iv(x, y)
}
\arguments{
\item{x}{an independent variable}

\item{y}{a binary response variable}
}
\value{
information value of \code{x}
}
\description{
Takes in independent and dependent variable and returns IV value
}
\details{
Information value of a variable is a significant indicator of its relevance in
 the prediction of a binary response variable. \code{iv} computes that value using
 the formula,
 IV = summation[(Responders - Non-responders)*ln(Responders / Non-responders) for
 each bin].

 Ten bins are created for continous variables while categories itself are used as
 bins for categorical independent variables.
}
\examples{
# A 'data.frame'
df <- data.frame(x = c('a', 'a', 'a', 'b', 'b', 'b'),
                 y = c(0, 1, 0, 1, 0, 1))

# Information value
IV <- iv(x = df[, 'x'], y = df[, 'y'])
}
\author{
Akash Jain
}
\seealso{
\code{\link{accuracy}}, \code{\link{auc}}, \code{\link{ks}}, \code{\link{splitdata}}
}

