% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/perfect_preservation.R
\name{perfect_preservation}
\alias{perfect_preservation}
\title{perfect taphonomic conditions}
\usage{
perfect_preservation(x)
}
\arguments{
\item{x}{time/stratigraphic position at which the taphonomic conditions are determined}
}
\value{
A vector of the same length as x with all entries replaced by 1.
}
\description{
Models perfect taphonomic conditions. Mainly used as default input to \code{last_occ} and \code{range_offset} or passed as \code{ctc} argument to \code{apply_taphonomy}.
}
\examples{
x = p3(rate = 10, 0, 1) # model fossils
y = apply_taphonomy(x, pres_potential = all_preserved, ctc = perfect_preservation)
all(x == y) # true, all fossils are preserved

}
\seealso{
\code{\link[=last_occ]{last_occ()}},  \code{\link[=range_offset]{range_offset()}}, \code{\link[=all_preserved]{all_preserved()}}, and \code{\link[=apply_taphonomy]{apply_taphonomy()}}
}
