% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_glmnet.R
\name{filter_glmnet}
\alias{filter_glmnet}
\title{Filter: Elastic Net (glmnet) Variable Importance}
\usage{
filter_glmnet(Y, A, X, lambda = "lambda.min", family = "gaussian", ...)
}
\arguments{
\item{Y}{The outcome variable. Must be numeric or survival (ex; Surv(time,cens) )}

\item{A}{Treatment variable. (a=1,...A)}

\item{X}{Covariate matrix. Must be numeric.}

\item{lambda}{Lambda for elastic net model (default="lambda.min"). Other options include
"lambda.1se" and fixed values}

\item{family}{Outcome type ("gaussian", "binomial", "survival"), default is "gaussian"}

\item{...}{Any additional parameters, not currently passed through.}
}
\value{
Filter model and variables that remain after filtering.
 \itemize{
  \item mod - Filtering model
  \item filter.vars - Variables that remain after filtering (could be all)
}
}
\description{
Filter variables through elastic net. Variables with zero coefficients
(depending on lambda choice; default is lambda.min) are filtered.
Usable for continuous, binary, and survival outcomes.
}
\examples{

library(StratifiedMedicine)

## Continuous ##
dat_ctns = generate_subgrp_data(family="gaussian")
Y = dat_ctns$Y
X = dat_ctns$X
A = dat_ctns$A

mod1 = filter_glmnet(Y, A, X)
mod2 = filter_glmnet(Y, A, X, lambda = "lambda.min") # same as default
mod3 = filter_glmnet(Y, A, X, lambda = "lambda.1se")
mod1$filter.vars
mod2$filter.vars
mod3$filter.vars
}
\seealso{
\code{\link{PRISM}}, \code{\link{glmnet}}
}
