% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PRISM_resamp.R
\name{PRISM_resamp}
\alias{PRISM_resamp}
\title{PRISM (Resample): Patient Response Identifier for Stratified Medicine}
\usage{
PRISM_resamp(PRISM.fit, Y, A, X, Xtest = NULL, family = "gaussian",
  filter = "filter_glmnet", ple = NULL, submod = NULL,
  param = NULL, alpha_ovrl = 0.05, alpha_s = 0.05,
  filter.hyper = NULL, ple.hyper = NULL, submod.hyper = NULL,
  param.hyper = NULL, verbose = TRUE, prefilter_resamp = FALSE,
  resample = "Bootstrap", R = NULL, stratify = TRUE,
  calibrate = TRUE, alpha.mat = NULL)
}
\arguments{
\item{PRISM.fit}{Fitted PRISM model}

\item{Y}{The outcome variable. Must be numeric or survival (ex; Surv(time,cens) )}

\item{A}{Treatment variable. (Default support binary treatment, either numeric or 
factor). 
If A=NULL, searches for prognostic variables (Y~X).}

\item{X}{Covariate space. Variables types (ex: numeric, factor, ordinal) should be set
to align with subgroup model (submod argument). For example, for lmtree, binary variables
coded as numeric (ex: 0, 1) are treated differently than the corresponding factor version
(ex: "A", "B"). Filter and PLE models provided in the StratifiedMedicine package can
accomodate all variable types.}

\item{Xtest}{Test set. Default is NULL which uses X (training set). Variable types should
match X.}

\item{family}{Outcome type. Options include "gaussion" (default), "binomial", and "survival".}

\item{filter}{Maps (Y,A,X) => (Y,A,X.star) where X.star has potentially less
covariates than X. Default is "filter_glmnet", "None" uses no filter.}

\item{ple}{PLE (Patient-Level Estimate) function. Maps the observed data to PLEs.
(Y,A,X) ==> PLE(X). Default for is "ple_ranger". For continuous/binomial outcome data,
this fits treatment specific random forest models. For survival outcome data, this 
fits a single forest, with expanded covariate space (A, X, X*A). 
(treatment-specific random forest models).  "None" uses no ple.}

\item{submod}{Subgroup identification model function. Maps the observed data and/or PLEs
to subgroups. Default of "gaussian"/"binomial" is "submod_lmtree" (MOB with OLS loss).
Default for "survival" is "submod_weibull" (MOB with weibull loss). "None" uses no 
submod.}

\item{param}{Parameter estimation and inference function. Based on the discovered subgroups,
perform inference through the input function (by name). Default for "gaussian"/"binomial" is
"param_PLE", default for "survival" is "param_cox".}

\item{alpha_ovrl}{Two-sided alpha level for overall population. Default=0.05}

\item{alpha_s}{Two-sided alpha level at subgroup level. Default=0.05}

\item{filter.hyper}{Hyper-parameters for the Filter function (must be list). Default is NULL.}

\item{ple.hyper}{Hyper-parameters for the PLE function (must be list). Default is NULL.}

\item{submod.hyper}{Hyper-parameters for the SubMod function (must be list). Default is NULL.}

\item{param.hyper}{Hyper-parameters for the Param function (must be list). Default is NULL.}

\item{verbose}{Detail progress of PRISM? Default=TRUE}

\item{prefilter_resamp}{Option to filter the covariate space (based on filter model) prior
to resampling. Default=FALSE.}

\item{resample}{Resampling method for resample-based estimates and variability metrics.
Options include "Bootstrap", "Permutation", and "CV" (cross-validation). 
Default=NULL (No resampling).}

\item{R}{Number of resamples (default=NULL; R=100 for Permutation/Bootstrap and 
R=5 for CV)}

\item{stratify}{Stratified resampling (Default=TRUE)}

\item{calibrate}{Bootstrap calibration for nominal alpha (Loh et al 2016).
Default=FALSE. For TRUE, outputs the calibrated alpha level and calibrated CIs for 
the overall population and subgroups. Not applicable for permutation/CV resampling.}

\item{alpha.mat}{Grid of alpha values for calibration. Default=NULL, which uses
seq(alpha/1000,alpha,by=0.005) for alpha_ovrl/alpha_s.}
}
\value{
Trained PRISM object. Includes filter, ple, submod, and param outputs.
 \itemize{
  \item param.dat - Parameter estimates and variablity metrics (depends on param)
  \item resamp.dist - - Resampling distributions
}
}
\description{
Based on initial PRISM fit (\code{PRISM_train}), run resampling (Boostrap, Permutation,
or cross-validation). Used directly in \code{PRISM}.
}
