% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neatPick.R
\name{neatPick}
\alias{neatPick}
\title{Interactive user modification of the arguments of a repeated function}
\usage{
neatPick(
  fun,
  n,
  args = list(),
  class.args = list(),
  pick = NA,
  fix = NA,
  buttonswidth = 2,
  text = "output",
  textwidth = 4,
  plotwidth = 800,
  plotheight = 600,
  args.only = F,
  width = 10,
  height = 10,
  name = "fig",
  dir = tempdir(),
  gfile = "onePDF",
  openfile = TRUE,
  folder = "Rfig",
  gfun = "jpeg",
  ext = ".jpeg",
  gargs = list(units = "in", res = 300),
  pargs = list(ps = 12, cex = 1.5)
)
}
\arguments{
\item{fun}{the function to be applied n times.}

\item{n}{number of runs.}

\item{args}{the arguments to be supplied to fun. Should be a list of
each argument to be supplied to fun, having n elements stored
indiscriminately in list or in vector form.}

\item{class.args}{the class of the arguments, in a list. This is
useful when the starting arguments are NA}

\item{pick}{which arguments to be able to adapt interactively}

\item{fix}{which arguments that cannot be chosen interactively (if
pick is NA)}

\item{buttonswidth}{the width of the buttons panel (integer from 1 to
12)}

\item{text}{which information to send to the text panel. The default
is the output of the current element (ni); "output". Can be the whole dataset
 of arguments; "all". Otherwise the panel does not show.}

\item{textwidth}{the width of the text panel (integer from 1 to 12)}

\item{plotwidth}{the width of the plot panel (arbitrary units)}

\item{plotheight}{the height of the plot panel (arbitrary units)}

\item{args.only}{whether to be only allowed to download and return
the arguments (this simplifies things and makes the workflow more efficient)}

\item{width, height, name, dir, gfile, openfile, folder, gfun, ext, gargs}{arguments to be supplied to neatPicked, the equivalent
of neatPick without interactivity: it runs the function for each ni and
saves the output (normal and graphical). In neatPick this happens when the
button 'Run and Download Output' is clicked. See ?neatPicked function help
page for details.}

\item{pargs}{the arguments to transmit to par(), in neatPick and
neatPicked}
}
\description{
This opens a shiny app that will allow to manipulate the
arguments of a function interactively, with different conditions that the
user can provide a priori and modify at will
}
\details{
This is a complicated function. A few basics:

neatPick works using the formals() function. It evaluates the arguments
and their default values of any function that you provide without
parentheses, like this for instance: \code{formals(multigons)}.

neatPick is capable of providing interaction with arguments of class integer
or numeric (e.g. 10, or 13,58745),  character (e.g. "BlipBlapBLoup") and
logical (T or F), as long as for each iteration (n) the length of the
argument is one (you cannot use arguments like xlim = c(0,1), however you can
use xmin = 0 and xmax = 1 for instance). But you can provide a different
value for each iteration n (if n = 3, you can provide col = c("red", "blue",
"green") in the args list of arguments)

You can chose which arguments are interactive or not using the 'pick' and
'fix' arguments.

To return the arguments or the output, you have to click on 'End & Return
Arguments' or 'End & Return Output', respectively.

You can also save the obtained output and arguments via the download buttons:
you geta .RData file were the arguments are in the object saved.arguments and
the output is in the saved.output object. The arguments can also be found at
saved.output$args. The arguments can be provided to the args argument of the
same neatPick function to rework the changes you made.
}
\examples{
\donttest{# You create a simple function. The one below creates sinusoidal waves between
# x0 = 0 and x1 = 1. You want to personalise the amplitude (delta), the y
# offset (pos, see ?sinpoint for more details), the phase (phase, expressed
# in multiples of pi), the number of waves between x0 and x1, and the number
# of intervals between each discrete point (nint).
# So you set all these as arguments of the function. This function can also
# have a graphical output of one plot (which can be subdivided if necessary
# using par(mfrow)). And the function can return output.

fun <- function(delta = 1, pos = 1, phase = 1.5, nwave = 1, nint = 50)
{

  res <- sinpoint(1, 0, delta = delta, pos = pos, phase = phase,
                  nwave = nwave, nint = nint)

  plot(res$x,res$y)

  return(res)

}

# Once this simple function is coded, it can be integrated to neatPick(). The
# argument n defines to number of different realisations of the function.

# WHEN YOU ARE HAPPY WITH THE OUTPUTS, click on 'END & RETURN ARGUMENTS'

a <- neatPick(fun, n = 10, args.only = TRUE)

# If you have clicked right (on the 'END & RETURN ARGUMENTS' button), the
# arguments will be returned and stored in a;

a

# These arguments can then serve for a more efficient function:

seg <- sinpoint(1, 0, delta = a$delta, pos = a$pos, phase = a$phase,
                nwave = a$nwave, nint = a$nint)

# Basically neatPick applies a for loop to fun, but if you work on a large
# dataset, you can also create a function that can handle the arguments more
# efficiently. This is what sinpoint does here

# Now you can see the results imported in R and do whatever you want with:

plot(seg$x, seg$y, type = "n")

multilines(seg$i, seg$x, seg$y)

# You can even rework your initial changes:

b <- neatPick(fun, n = 10, args.only = TRUE, args = a)}

}
