% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simp.lim.R
\name{simp.lim}
\alias{simp.lim}
\title{Joins and orders adjacent or overlapping lim objects of same ID}
\usage{
simp.lim(lim = NULL, l = NULL, r = NULL, id = 1L, b = "[]")
}
\arguments{
\item{lim}{an object convertible into a lim object: either a vector
of length 2 or a list of n left (1st element) and n right (2ndt element)
interval limits}

\item{l}{a vector of n left interval limits}

\item{r}{a vector of n right interval limits}

\item{id}{a vector of n interval IDs (default is 1 for each interval)}

\item{b}{a character vector for the interval boundaries rules: "[]"
(or "closed") to include both boundaries points, "][" (or "()" and "open") to
exclude both boundary points, "[[" (or "[)","right-open" and"left-closed") to
include only the left boundary point, and "]]" (or "(]", "left-open",
"right-closed") to include only the right boundary point. The notation is
simplified to "[]", "[[", "]]" and "][" only.}
}
\value{
a lim object of the joined intervals
}
\description{
Joins and orders adjacent or overlapping lim objects of same ID
}
\examples{
l   <- c(50,2,4,6,50,8,50,51,50,80)
r   <- c(50,5,6,9,8,2,51,51,50,80)
id  <- c("i1", "i1", "i1", "i1", "i2","i2","i2","i2","i2","i2")
b   <- c("[]", "][", "][", "]]", "][","[[","][","][","][","][")

simp.lim(l = l, r = r, id = id, b = b)

}
\seealso{
\code{\link{as.lim}}
}
