% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clipsvg.R
\name{clipsvg}
\alias{clipsvg}
\title{Clips a standardised pointsvg object into a given frame}
\usage{
clipsvg(
  object,
  xmin = -Inf,
  xmax = +Inf,
  ymin = -Inf,
  ymax = +Inf,
  by.entity = TRUE
)
}
\arguments{
\item{object}{a pointsvg object (svg object imported as data frame
using \code{\link{pointsvg}}).}

\item{xmin, xmax, ymin, ymax}{clipping coordinates, default to +-Inf (no
clipping)}

\item{by.entity}{whether to remove all entities having points out of
the clipping zone (TRUE; default) or to only remove the points out it (FALSE,
and to use on lines for better result)}
}
\description{
Clips a svg object imported as data frame using
\code{\link{pointsvg}} if outside of a given frame. In other words it removes
the elements of the svg that are entirely outside a given area.
}
\examples{
# Simple use

object <- example.ammonite

plot(c(-1,1), c(-1,1), type = "n", ylab = "y", xlab = "x")

res.object <- clipsvg(object, xmax = 0.5)

abline(v = 0.5)

centresvg(object, 0, 0, lty = 2)
centresvg(res.object, 0, 0, col = "red", lwd = 2)

# Advanced used

object2 <- example.breccia

plot(c(-1,3), c(-1,11), type = "n", ylab = "y", xlab = "x")

object2replicated <- framesvg(object2, 0,2,c(0,4,8), c(2,6,10),
                              output = TRUE)

object2clipped    <- clipsvg(object2replicated, 0, 1.7, 1, 9)

rect(0, 1, 1.7, 9, border = "red")

placesvg(object2clipped, border = "red", lwd = 2)

}
\seealso{
\code{\link{centresvg}}, \code{\link{changesvg}},
\code{\link{framesvg}} and \code{\link{pointsvg}}

If you want to also keep the elements that are only partly inside the
clipping region: \code{\link{ignore}}
}
