% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collection.R
\name{collection}
\alias{collection}
\alias{is.collection}
\alias{plot_collection}
\title{Create a list of symbols}
\usage{
collection(dir = getwd())

is.collection(collection)

plot_collection(
  collection,
  col = "grey90",
  cex = 2,
  as.pdf = T,
  name = "symbols",
  ext = ".pdf",
  dir = tempdir(),
  width = 7,
  height = 0.8 * width/5.6,
  track = T,
  openfile = T
)
}
\arguments{
\item{dir}{the file where the document will be saved (by default a temporary
directory, tempdir())}

\item{collection}{an object similar to the output of collection()}

\item{col}{the background colour of the symbols}

\item{cex}{the size of the text in the plot}

\item{as.pdf}{whether to output the plot as a pdf}

\item{name}{the name of the pdf document to plot the symbols of a collection}

\item{ext}{the extension of the document: ".pdf" by default, but
".svg" works also.}

\item{width}{the width of the drawing area (in inches)}

\item{height}{the height of the drawing area (in inches)}

\item{track}{whether to generate different files for each rerun of pdfDisplay
with identical 'name'. The name will be followed by '_(i)' where i is the
version number. With this you avoid closing your pdf file at each rerun if
your pdf reader is not able to deal with (to my knowledge only SumatraPDF is
able)}

\item{openfile}{should the pdf file be opened (for the moment works
only in Windows). Use SumatraPDF as default pdf reader to be able to write
over current file}
}
\value{
a collection is a list of pointsvg-objects
(see \code{\link{pointsvg}})
}
\description{
From a file containing SVG files, extracts all the SVGs into
a list of symbols that can be used in lithologs.
}
\examples{
# To show you how to import, we first have to have a svg file to import. The
# following lines of code will create a svg in a temporary files:

# 1. Create temporary file
svg.file.directory <- tempfile(pattern = "ammonite",
                               fileext = ".svg")
# 2. Write the svg in the file
writeLines(example.ammonite.svg, svg.file.directory)

print(paste("An example .svg file was created at ", svg.file.directory,
            sep = ""))

coll <- collection(dirname(svg.file.directory))

is.collection(coll)

\dontrun{
plot_collection(coll, cex = 1.5)

plot_collection(oufti99, name = "Oufti99")}

}
