% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weldprofile.R
\name{weldprofile}
\alias{weldprofile}
\title{Changes profiles in basic lithologs}
\usage{
weldprofile(log, gap, dt, xy, i = NA, ext = Inf, tolerance = 8, correct = T)
}
\arguments{
\item{log}{a "litholog()"-like data frame on which the new profile needs to
be welded.}

\item{gap}{The xy value delimiting the litholog in the parts that will
remain, and the parts that will be replaced by the profile. This should be
comparable to the most inward values of the profile. What side of the
litholog will remain depends on the ext parameter.}

\item{dt, xy}{the depth and intensity values for the profile}

\item{i}{the beds ids for the points of the profile (is optional; this is
useful for complex profiles, which can go back and forth in depth).}

\item{ext}{the most outward values of the profile; defaults to infinity Inf,
for "left-side" profiles, set to -Inf.}

\item{tolerance}{the order of tolerance for errors, i.e. the number of
decimals considered as being meaningful for matching dt to log}

\item{correct}{this parameter applies in a very specific case, when i is
provided, and when the order of points is not straightforward (going from low
to high values, or vice versa). If correct is TRUE, the ambiguous parts
(in ambiguous beds) of the profile will be reversed.}
}
\value{
A litholog object, i.e., a table of bed id (i), depth (dt) and xy
values (the x position if your litholog is vertical).
}
\description{
Adds profiles (hardness, weathering, grain-size, facies, etc.)
to lithologs from "litholog()"-like data frames
}
\examples{
# Make an initial log ----

r <- c(1,2,3,4,5)  # left boundary of the bed interval (upper or lower)
l <- c(0,1,2,3,4)  # right boundary of the bed interval (upper or lower)
h <- c(4,3,5,3,4) # hardness (arbitrary)
i <- c("B1","B2","B3","B4","B5") # Bed name

log <- litholog(l,r,h,i) # Generate data frame of the polygons
# making the litholog

# Define the profile ----

# Depths (dt), intensity (xy), and ids (id) of profile points
dt <- c(0,1,1,1,2,2,2,3,3,3,4,4,5)
xy <- c(5,4,3,4,3,3,6,5,3,4,3,5,4)
id <- c("B1","B1","B1","B2","B2","B3","B3","B3","B3","B4","B4","B5","B5")

# Weld profile to litholog ----

nlog <- weldprofile(log = log, gap = 3, dt = dt, xy = xy, i = id, ext = Inf)

# Visualisation ----

opar <- par()$mfrow
par(mfrow = c(1,3))

plot.new()
plot.window(xlim = c(0,6), ylim = c(0,5))

axis(1)
axis(2)

multigons(log$i, log$xy, log$dt)

plot.new()
plot.window(xlim = c(0,6), ylim = c(0,5))

axis(1)
axis(2)

lines(xy, dt, type = "o", pch = 19)

plot.new()
plot.window(xlim = c(0,6), ylim = c(0,5))

axis(1)
axis(2)

multigons(nlog$i, nlog$xy, nlog$dt)

par(mfrow = opar)

}
