% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotDScoreHeatmap.R
\name{plotDScoreHeatmap}
\alias{plotDScoreHeatmap}
\title{Plot a heat map of the normalized drug-disease reverse association scores for cancer samples}
\usage{
plotDScoreHeatmap(
  data,
  subtype.label = "all",
  SDS = "all",
  E_Pvalue.th = 0.05,
  E_FDR.th = 0.05,
  S_Pvalue.th = 0.05,
  S_FDR.th = 0.05,
  show.rownames = TRUE,
  show.colnames = TRUE,
  fontsize = 10,
  fontsize.row = 10,
  fontsize.col = 10,
  scale = "row"
)
}
\arguments{
\item{data}{A list of result data generated by function `OCSSD()`.}

\item{subtype.label}{Character string indicates which sample of the cancer subtype was used to plot the heat map.
If subtype.label = "all" (default), all cancer samples will be shown in the heat map.}

\item{SDS}{A string indicates that the range of SDS is used for the heat map. if SDS="all" (default), the SDS will not be screened.
SDS="negative", only drugs with SDS<0 are used. SDS="positive", only drugs with SDS>0 are used.}

\item{E_Pvalue.th}{A numeric.A threshold is used to screen the drug effected P value.}

\item{E_FDR.th}{A numeric.A threshold is used to screen the drug effected FDR.}

\item{S_Pvalue.th}{A numeric.A threshold is used to screen the Subtype specific P value.}

\item{S_FDR.th}{A numeric.A threshold is used to screen the Subtype specific P value.}

\item{show.rownames}{Boolean specifying if row names are be shown.}

\item{show.colnames}{Boolean specifying if column names are be shown.}

\item{fontsize}{Base fontsize for the plot (default: 10).}

\item{fontsize.row}{Fontsize for rownames (default: 10).}

\item{fontsize.col}{Fontsize for colnames (default: 10).}

\item{scale}{Character indicating if the values should be centered and scaled in either the row direction or the column direction, or none. Corresponding values are "row" (default), "column" and "none".}
}
\value{
A heat map.
}
\description{
The `plotDScoreHeatmap()` screen for significant cancer related
or cancer subtype specific drugs based on user set FDR threshold and sutype-specific drug score (SDS) range. And
shown in the form of a heat map.
}
\details{
plotDScoreHeatmap
}
\examples{
require(pheatmap)
## Get the result data of OCSSD().
## The data is based on the simulated breast cancer subtype data.
Subtype_drugs<-get("Subtype_drugs")
## Heat map of all subtype-specific drugs.
\donttest{plotDScoreHeatmap(data=Subtype_drugs,E_Pvalue.th=0.05,E_FDR.th=1,
                            S_Pvalue.th=0.05,S_FDR.th=1)}
## Plot only Basal subtype-specific drugs.
plotDScoreHeatmap(Subtype_drugs,subtype.label="Basal",SDS="all",E_Pvalue.th=0.05,E_FDR.th=1,
                  S_Pvalue.th=0.05,S_FDR.th=1,show.colnames = FALSE)
}
\author{
Xudong Han,
Junwei Han,
Chonghui Liu
}
