% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fbm_msd.R
\name{fbm_msd}
\alias{fbm_msd}
\title{Mean square displacement of fractional Brownian motion.}
\usage{
fbm_msd(tseq, H)
}
\arguments{
\item{tseq}{Length-\code{N} vector of timepoints.}

\item{H}{Hurst parameter (between 0 and 1).}
}
\value{
Length-\code{N} vector of mean square displacements.
}
\description{
Mean square displacement of fractional Brownian motion.
}
\details{
The mean squared displacement (MSD) of a stochastic process \code{X_t} is defined as\preformatted{MSD(t) = E[(X_t - X_0)^2].
}

Fractional Brownian motion (fBM) is a continuous Gaussian process with stationary increments, such that its covariance function is entirely defined the MSD, which in this case is \verb{MSD(t) = |t|^(2H)}.
}
\examples{
fbm_msd(tseq = 1:10, H = 0.4)
}
