% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fraidm.R
\name{fraidm}
\alias{fraidm}
\title{Frailty with Discrete Mixture  Model}
\usage{
fraidm(m, n, Inst, Delta, Time, T.min, chains, iter, data)
}
\arguments{
\item{m}{Starting column number form where study variables to be selected.}

\item{n}{Ending column number till where study variables will get selected.}

\item{Inst}{Variable name of Institute information.}

\item{Delta}{Variable name containing the event information.}

\item{Time}{Variable name containing the time information.}

\item{T.min}{Variable name containing the time of event information.}

\item{chains}{Number of MCMC chains}

\item{iter}{Define number of iterations as number.}

\item{data}{High dimensional data, event information given as (delta=0 if alive, delta=1 if died). If patient is censored then t.min=duration of survival. If patient is died then t.min=0. If patient is died then t=duration of survival. If patient is alive then t=NA.}
}
\value{
fraidmout - b[1] is the posterior estimate of the regression coefficient for first covariate.


b[2] is the posterior estimate of the regression coefficient for second covariate.


b[3] is the posterior estimate of the regression coefficient for third covariate.


omega[1] and omega[2] are frailty effects.


c[1] and c[2] are regression intercept and coefficients of covariates over mean effect.


deviance is the model diagnostic criteria.
}
\description{
Discrete mixture model with MCMC
}
\details{
By given m and n, a total of 3 variables can be selected.
}
\examples{
\dontrun{
##
data(frailty)
fraidm(5,7,Inst="institute",Delta="del",Time="timevar",T.min="time.min",2,7,frailty)
##
}
}
\references{
Bhattacharjee, A. (2020). Bayesian Approaches in Oncology Using
R and OpenBUGS. CRC Press.

Congdon, P. (2014). Applied bayesian modelling (Vol. 595).
John Wiley & Sons.

{
}
}
\seealso{
fraidpm frairand
}
